/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

@Singleton
public class DifferentFiles {
    private static final String HEAD = "HEAD";
    private static final String REFS_REMOTES = "refs/remotes/";
    private static final String REFS_HEADS = "refs/heads/";
    @Inject
    private Git git;
    @Inject
    private Configuration configuration;
    @Inject
    private Logger logger;

    public Set<Path> get() throws GitAPIException, IOException {
        this.fetch();
        this.checkout();
        RevCommit base = this.getBranchCommit(this.configuration.baseBranch);
        TreeWalk treeWalk = new TreeWalk(this.git.getRepository());
        treeWalk.addTree((AnyObjectId)base.getTree());
        treeWalk.addTree((AnyObjectId)this.resolveReference(base).getTree());
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        treeWalk.setRecursive(true);
        Path workTree = this.git.getRepository().getWorkTree().toPath().normalize().toAbsolutePath();
        Set<Path> paths = this.getDiff(treeWalk, workTree);
        if (this.configuration.uncommited) {
            paths.addAll(this.getUncommitedChanges(workTree));
        }
        treeWalk.close();
        this.git.getRepository().close();
        this.git.close();
        return paths;
    }

    private void checkout() throws IOException, GitAPIException {
        if (!(HEAD.equals(this.configuration.baseBranch) || this.configuration.baseBranch.startsWith("worktrees/") || this.git.getRepository().getFullBranch().equals(this.configuration.baseBranch))) {
            this.logger.info("Checking out base branch " + this.configuration.baseBranch + "...");
            this.git.checkout().setName(this.configuration.baseBranch).call();
        }
    }

    private void fetch() throws GitAPIException {
        if (this.configuration.fetchReferenceBranch) {
            this.fetch(this.configuration.referenceBranch);
        }
        if (this.configuration.fetchBaseBranch) {
            this.fetch(this.configuration.baseBranch);
        }
    }

    private void fetch(String branchName) throws GitAPIException {
        this.logger.info("Fetching branch " + branchName);
        if (!branchName.startsWith(REFS_REMOTES)) {
            throw new IllegalArgumentException("Branch name '" + branchName + "' is not tracking branch name since it does not start " + REFS_REMOTES);
        }
        String remoteName = this.extractRemoteName(branchName);
        String shortName = this.extractShortName(remoteName, branchName);
        this.git.fetch().setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(REFS_HEADS + shortName + ":" + branchName)}).call();
    }

    private String extractRemoteName(String branchName) {
        return branchName.split("/")[2];
    }

    private String extractShortName(String remoteName, String branchName) {
        return branchName.replaceFirst(REFS_REMOTES + remoteName + "/", "");
    }

    private RevCommit getMergeBase(RevCommit baseCommit, RevCommit referenceHeadCommit) throws IOException {
        RevWalk walk = new RevWalk(this.git.getRepository());
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(walk.lookupCommit((AnyObjectId)baseCommit));
        walk.markStart(walk.lookupCommit((AnyObjectId)referenceHeadCommit));
        RevCommit commit = walk.next();
        walk.close();
        this.logger.info("Using merge base of id: " + commit.getId());
        return commit;
    }

    private Set<Path> getDiff(TreeWalk treeWalk, Path gitDir) throws IOException {
        HashSet<Path> paths = new HashSet<Path>();
        while (treeWalk.next()) {
            Path path = gitDir.resolve(treeWalk.getPathString()).normalize();
            if (this.configuration.excludePathRegex.test(path.toString())) continue;
            paths.add(path);
        }
        return paths;
    }

    private RevCommit getBranchCommit(String branchName) throws IOException {
        ObjectId objectId = this.git.getRepository().resolve(branchName);
        if (objectId == null) {
            throw new IllegalArgumentException("Git branch of name '" + branchName + "' not found.");
        }
        RevWalk walk = new RevWalk(this.git.getRepository());
        RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
        walk.close();
        this.logger.info("Reference commit of branch " + branchName + " is commit of id: " + commit.getId());
        return commit;
    }

    private Set<Path> getUncommitedChanges(Path gitDir) throws GitAPIException {
        return this.git.status().call().getUncommittedChanges().stream().map(gitDir::resolve).map(Path::normalize).collect(Collectors.toSet());
    }

    private RevCommit resolveReference(RevCommit base) throws IOException {
        RevCommit refHead = this.getBranchCommit(this.configuration.referenceBranch);
        if (this.configuration.compareToMergeBase) {
            return this.getMergeBase(base, refHead);
        }
        return refHead;
    }
}

