/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.control.DifferentFiles;
import com.vackosar.gitflowincrementalbuild.control.Modules;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;

@Singleton
public class ChangedProjects {
    @Inject
    private Logger logger;
    @Inject
    private DifferentFiles differentFiles;
    @Inject
    private MavenSession mavenSession;
    @Inject
    private Modules modules;

    public Set<MavenProject> get() throws GitAPIException, IOException {
        return this.differentFiles.get().stream().map(path -> this.findProject((Path)path, this.mavenSession)).filter(project -> project != null).collect(Collectors.toSet());
    }

    private MavenProject findProject(Path diffPath, MavenSession mavenSession) {
        Path path;
        Map<Path, MavenProject> map = this.modules.createPathMap(mavenSession);
        for (path = diffPath; path != null && !map.containsKey(path); path = path.getParent()) {
        }
        if (path != null) {
            this.logger.debug("Changed file: " + diffPath);
            return map.get(path);
        }
        this.logger.warn("Changed file outside build project: " + diffPath);
        return null;
    }
}

