/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.google.inject.Singleton;
import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.ChangedProjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;

@Singleton
class UnchangedProjectsRemover {
    private static final String MAVEN_TEST_SKIP = "maven.test.skip";
    private static final String MAVEN_TEST_SKIP_EXEC = "skipTests";
    static final String TEST_JAR_DETECTED = "Dependency with test-jar goal detected. Will compile test sources.";
    private static final String GOAL_TEST_COMPILE = "test-compile";
    private static final String GOAL_TEST_JAR = "test-jar";
    @Inject
    private Configuration configuration;
    @Inject
    private Logger logger;
    @Inject
    private ChangedProjects changedProjects;
    @Inject
    private MavenSession mavenSession;

    UnchangedProjectsRemover() {
    }

    void act() throws GitAPIException, IOException {
        Set<MavenProject> changed = this.changedProjects.get();
        this.printDelimiter();
        this.logProjects(changed, "Changed Artifacts:");
        Set<MavenProject> impacted = this.mavenSession.getProjects().stream().filter(changed::contains).flatMap(p -> this.getAllDependents(this.mavenSession.getProjects(), (MavenProject)p).stream()).collect(Collectors.toSet());
        if (!this.configuration.buildAll) {
            Set<MavenProject> rebuild = this.getRebuildProjects(impacted);
            if (rebuild.isEmpty()) {
                this.logger.info("No changed artifacts to build. Executing validate goal only.");
                this.mavenSession.getGoals().clear();
                this.mavenSession.getGoals().add("validate");
            } else {
                this.mavenSession.setProjects(new ArrayList<MavenProject>(rebuild));
            }
        } else {
            this.mavenSession.getProjects().stream().filter(p -> !impacted.contains(p)).forEach(this::ifSkipDependenciesTest);
        }
    }

    private Set<MavenProject> getRebuildProjects(Set<MavenProject> changedProjects) {
        if (this.configuration.makeUpstream) {
            return Stream.concat(changedProjects.stream(), this.collectDependencies(changedProjects)).collect(Collectors.toSet());
        }
        return changedProjects;
    }

    private Stream<MavenProject> collectDependencies(Set<MavenProject> changedProjects) {
        return changedProjects.stream().flatMap(this::ifMakeUpstreamGetDependencies).filter(p -> !changedProjects.contains(p)).map(this::ifSkipDependenciesTest);
    }

    private MavenProject ifSkipDependenciesTest(MavenProject mavenProject) {
        if (this.configuration.skipTestsForNotImpactedModules) {
            if (this.projectDeclaresTestJarGoal(mavenProject)) {
                this.logger.debug(mavenProject.getArtifactId() + ": " + TEST_JAR_DETECTED);
                mavenProject.getProperties().setProperty(MAVEN_TEST_SKIP_EXEC, Boolean.TRUE.toString());
            } else {
                mavenProject.getProperties().setProperty(MAVEN_TEST_SKIP, Boolean.TRUE.toString());
            }
        }
        return mavenProject;
    }

    private boolean projectDeclaresTestJarGoal(MavenProject mavenProject) {
        return mavenProject.getBuildPlugins().stream().flatMap(p -> p.getExecutions().stream()).flatMap(e -> e.getGoals().stream()).filter(GOAL_TEST_JAR::equals).findAny().isPresent();
    }

    private void logProjects(Set<MavenProject> projects, String title) {
        this.logger.info(title);
        this.logger.info("");
        projects.stream().map(MavenProject::getArtifactId).forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
        this.logger.info("");
    }

    private void printDelimiter() {
        this.logger.info("------------------------------------------------------------------------");
    }

    private Set<MavenProject> getAllDependents(List<MavenProject> projects, MavenProject project) {
        HashSet<MavenProject> result = new HashSet<MavenProject>();
        result.add(project);
        for (MavenProject possibleDependent : projects) {
            if (this.isDependentOf(possibleDependent, project)) {
                result.addAll(this.getAllDependents(projects, possibleDependent));
            }
            if (!project.equals((Object)possibleDependent.getParent())) continue;
            result.addAll(this.getAllDependents(projects, possibleDependent));
        }
        return result;
    }

    private Stream<MavenProject> ifMakeUpstreamGetDependencies(MavenProject mavenProject) {
        return this.getAllDependencies(this.mavenSession.getProjects(), mavenProject).stream();
    }

    private Set<MavenProject> getAllDependencies(List<MavenProject> projects, MavenProject project) {
        Set<MavenProject> dependencies = project.getDependencies().stream().map(d -> this.convert(projects, (Dependency)d)).filter(Optional::isPresent).map(Optional::get).flatMap(p -> this.getAllDependencies(projects, (MavenProject)p).stream()).collect(Collectors.toSet());
        dependencies.add(project);
        return dependencies;
    }

    private boolean equals(MavenProject project, Dependency dependency) {
        return dependency.getArtifactId().equals(project.getArtifactId()) && dependency.getGroupId().equals(project.getGroupId()) && dependency.getVersion().equals(project.getVersion());
    }

    private Optional<MavenProject> convert(List<MavenProject> projects, Dependency dependency) {
        return projects.stream().filter(p -> this.equals((MavenProject)p, dependency)).findFirst();
    }

    private boolean isDependentOf(MavenProject possibleDependent, MavenProject project) {
        return possibleDependent.getDependencies().stream().anyMatch(d -> this.equals(project, (Dependency)d));
    }
}

