/*
 * Decompiled with CFR 0.152.
 */
package com.jz.website.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.NewsInfo;
import com.jz.jooq.website.tables.NewsSchool;
import com.jz.website.repository.WebsiteBaseRepository;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class NewsInfoRepository
extends WebsiteBaseRepository {
    private static final NewsInfo NI = Tables.NEWS_INFO;
    private static final NewsSchool NS = Tables.NEWS_SCHOOL;

    private Condition getCondition(String school, Integer tid) {
        return NewsInfoRepository.NS.SCHOOL_ID.eq((Object)school).and(NewsInfoRepository.NS.TID.eq((Object)tid)).and(NewsInfoRepository.NS.STATUS.eq((Object)1));
    }

    public int cntNews(String school, Integer tid) {
        return this.websiteCtx.fetchCount((Table)NS, this.getCondition(school, tid));
    }

    public List<String> getNewsId(String school, Integer tid, int start, int size) {
        return this.websiteCtx.select((SelectField)NewsInfoRepository.NS.NID).from((TableLike)NS).where(new Condition[]{this.getCondition(school, tid)}).orderBy(NewsInfoRepository.NS.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<com.jz.jooq.website.tables.pojos.NewsInfo> getListNewsInfo(List<String> nids) {
        return this.websiteCtx.select((SelectField)NewsInfoRepository.NI.ID, (SelectField)NewsInfoRepository.NI.SCHOOL_ID, (SelectField)NewsInfoRepository.NI.TITLE, (SelectField)NewsInfoRepository.NI.PIC, (SelectField)NewsInfoRepository.NI.CREATE_TIME).from((TableLike)NI).where(new Condition[]{NewsInfoRepository.NI.ID.in(nids)}).orderBy(NewsInfoRepository.NI.CREATE_TIME.desc()).fetchInto(com.jz.jooq.website.tables.pojos.NewsInfo.class);
    }

    public com.jz.jooq.website.tables.pojos.NewsInfo getNewsInfo(String nid) {
        return (com.jz.jooq.website.tables.pojos.NewsInfo)ArrayMapTools.getFirst((Collection)this.websiteCtx.selectFrom((Table)NI).where(new Condition[]{NewsInfoRepository.NI.ID.eq((Object)nid)}).fetchInto(com.jz.jooq.website.tables.pojos.NewsInfo.class));
    }

    public List<com.jz.jooq.website.tables.pojos.NewsInfo> getBannerNewsInfo(List<String> nids) {
        return this.websiteCtx.select((SelectField)NewsInfoRepository.NI.ID, (SelectField)NewsInfoRepository.NI.TITLE, (SelectField)NewsInfoRepository.NI.BANNER_PIC).from((TableLike)NI).where(new Condition[]{NewsInfoRepository.NI.ID.in(nids)}).fetchInto(com.jz.jooq.website.tables.pojos.NewsInfo.class);
    }
}

