/*
 * Decompiled with CFR 0.152.
 */
package com.jz.website.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.ArtSchool;
import com.jz.jooq.website.tables.pojos.Art;
import com.jz.website.repository.WebsiteBaseRepository;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ArtRepository
extends WebsiteBaseRepository {
    private static final com.jz.jooq.website.tables.Art ART = Tables.ART;
    private static final ArtSchool AS = Tables.ART_SCHOOL;

    private Condition getCondition(String school) {
        return ArtRepository.AS.SCHOOL_ID.eq((Object)school).and(ArtRepository.AS.STATUS.eq((Object)1));
    }

    public int cntArt(String school) {
        return this.websiteCtx.fetchCount((Table)AS, this.getCondition(school));
    }

    public List<String> getArtId(String school, int start, int size) {
        return this.websiteCtx.select((SelectField)ArtRepository.AS.AID).from((TableLike)AS).where(new Condition[]{this.getCondition(school)}).orderBy(ArtRepository.AS.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<Art> getListArtInfo(List<String> aids) {
        return this.websiteCtx.select((SelectField)ArtRepository.ART.ID, (SelectField)ArtRepository.ART.TITLE, (SelectField)ArtRepository.ART.PIC, (SelectField)ArtRepository.ART.VIDEO_URL, (SelectField)ArtRepository.ART.BABY_NAME, (SelectField)ArtRepository.ART.BABY_AGE).from((TableLike)ART).where(new Condition[]{ArtRepository.ART.ID.in(aids)}).orderBy(ArtRepository.ART.CREATE_TIME.desc()).fetchInto(Art.class);
    }

    public Art getArtInfo(String aid) {
        return (Art)ArrayMapTools.getFirst((Collection)this.websiteCtx.selectFrom((Table)ART).where(new Condition[]{ArtRepository.ART.ID.eq((Object)aid)}).fetchInto(Art.class));
    }

    public List<Art> getBannerArtInfo(List<String> aids) {
        return this.websiteCtx.select((SelectField)ArtRepository.ART.ID, (SelectField)ArtRepository.ART.TITLE, (SelectField)ArtRepository.ART.BANNER_PIC).from((TableLike)ART).where(new Condition[]{ArtRepository.ART.ID.in(aids)}).fetchInto(Art.class);
    }
}

