package com.jz.website.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.NewsInfo;

@Lazy
@Repository
public class NewsInfoRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.NewsInfo NI = Tables.NEWS_INFO;
	private static final com.jz.jooq.website.tables.NewsSchool NS = Tables.NEWS_SCHOOL;

	private Condition getCondition(String school, Integer tid) {
		return NS.SCHOOL_ID.eq(school).and(NS.TID.eq(tid)).and(NS.STATUS.eq(1));
	}

	public int cntNews(String school, Integer tid) {
		return websiteCtx.fetchCount(NS, getCondition(school, tid));
	}

	public List<String> getNewsId(String school, Integer tid, int start, int size) {
		// 0未发布 1已发布 2取消发布 -1删除
		return websiteCtx.select(NS.NID).from(NS).where(getCondition(school, tid)).orderBy(NS.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<NewsInfo> getListNewsInfo(List<String> nids) {
		return websiteCtx.select(NI.ID, NI.SCHOOL_ID, NI.TITLE, NI.PIC, NI.CREATE_TIME).from(NI).where(NI.ID.in(nids))
				.orderBy(NI.CREATE_TIME.desc()).fetchInto(NewsInfo.class);
	}

	public NewsInfo getNewsInfo(String nid) {
		return ArrayMapTools.getFirst(websiteCtx.selectFrom(NI).where(NI.ID.eq(nid)).fetchInto(NewsInfo.class));
	}

	public List<NewsInfo> getBannerNewsInfo(List<String> nids) {
		return websiteCtx.select(NI.ID, NI.TITLE, NI.BANNER_PIC).from(NI).where(NI.ID.in(nids))
				.fetchInto(NewsInfo.class);
	}
}
