package com.jz.website.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.BrandIntro;

@Lazy
@Repository
public class BrandIntroRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.BrandIntro BI = Tables.BRAND_INTRO;

	public BrandIntro getBrandIntro(String brand) {
		return ArrayMapTools.getFirst(websiteCtx.selectFrom(BI).where(BI.BRAND.eq(brand)).fetchInto(BrandIntro.class));
	}

}
