/*
 * Decompiled with CFR 0.152.
 */
package com.jz.tool.token.configuration;

import com.jz.common.utils.text.StringTools;
import com.jz.tool.token.annotation.WebTokenFilter;
import com.jz.tool.token.configuration.DiscoveryTokenFilter;
import com.jz.tool.token.exception.TokenBeansException;
import com.jz.tool.token.proxy.TokenFilterCglibProxy;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TokenBeanDefinitionRegisterProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final String tokenEnabledKey = "com.jz.tools.token.enabled";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("application");
        if (resourceBundle.containsKey(tokenEnabledKey) && "false".equals(resourceBundle.getString(tokenEnabledKey))) {
            return;
        }
        Class<?> tokenFilterClass = this.getTokenFilterClass();
        if (null == tokenFilterClass) {
            return;
        }
        WebTokenFilter tokenFilter = tokenFilterClass.getAnnotation(WebTokenFilter.class);
        TokenFilterCglibProxy cglibProxy = new TokenFilterCglibProxy(tokenFilterClass);
        String beanName = tokenFilterClass.getSimpleName().substring(0, 1).toLowerCase();
        beanName = StringTools.ternary((String)tokenFilter.value(), (String)(beanName + tokenFilterClass.getSimpleName().substring(1)));
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(FilterRegistrationBean.class);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        propertyValues.add("filter", cglibProxy.getDynamicProxyInstance());
        propertyValues.add("order", (Object)tokenFilter.order());
        propertyValues.add("urlPatterns", Arrays.asList(tokenFilter.urlPatterns()));
        propertyValues.add("name", (Object)beanName);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private Class<?> getTokenFilterClass() {
        try {
            return DiscoveryTokenFilter.discoveryMappingUrl("com.jz");
        }
        catch (IOException | ClassNotFoundException | URISyntaxException e) {
            throw new TokenBeansException("Cann't found token filter class");
        }
    }
}

