/*
 * Decompiled with CFR 0.152.
 */
package com.jz.tool.token.configuration;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.io.ClassTools;
import com.jz.tool.token.annotation.WebTokenFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DiscoveryTokenFilter {
    public static Class<?> discoveryMappingUrl(String ... packages) throws IOException, ClassNotFoundException, URISyntaxException {
        List urls = ClassTools.findResourcesForPackage((String[])packages);
        if (ArrayMapTools.isEmpty((Collection)urls)) {
            return null;
        }
        for (URL url : DiscoveryTokenFilter.getClassUrl(urls)) {
            Class clazz = ClassTools.getClass((URL)url);
            if (!clazz.isAnnotationPresent(WebTokenFilter.class)) continue;
            return clazz;
        }
        return null;
    }

    private static List<URL> getClassUrl(List<URL> urls) throws ClassNotFoundException, IOException, URISyntaxException {
        ArrayList classUrls = Lists.newArrayList();
        for (URL url : urls) {
            if ("jar".equals(url.getProtocol())) {
                classUrls.addAll(ClassTools.getClassUrlsForJar((URL)url));
                continue;
            }
            classUrls.addAll(ClassTools.getClassUrlsForFiles((URL)url));
        }
        return classUrls;
    }
}

