package com.jz.web.mvc.common.configuration;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.jz.common.utils.collection.ArrayMapTools;

/**
 * @author 连杰
 */
@EnableSwagger2
public abstract class Swagger2RegistryConfig {

	private static Logger logger = LoggerFactory.getLogger(Swagger2RegistryConfig.class);

	@Bean
	public Docket petApi() throws ClassNotFoundException, IOException, URISyntaxException {
		logger.info("Loadding Swagger Interfaces Infomation [Title : {} , creater : {}]", title(), creater());
		return new Docket(DocumentationType.SWAGGER_2).groupName("full-api").apiInfo(apiInfo()).select()
				.paths(petstorePaths()).build().useDefaultResponseMessages(false);
	}

	public abstract String[] swaggerPackages();

	@SuppressWarnings("unchecked")
	public Predicate<String> petstorePaths() throws ClassNotFoundException, IOException, URISyntaxException {
		List<String> urls = DiscoverySwagger.discoveryMappingUrl(swaggerPackages());
		if (ArrayMapTools.isEmpty(urls))
			return Predicates.or();
		Predicate<String>[] predicates = new Predicate[urls.size()];
		for (int i = 0; i < urls.size(); i++) {
			predicates[i] = PathSelectors.regex(urls.get(i));
		}
		return Predicates.or(predicates);
	}

	public String title() {
		return "接口说明文档";
	}

	public String description() {
		return "详细说明(可覆盖父类方法)";
	}

	public String creater() {
		return "creater";
	}

	private ApiInfo apiInfo() {
		return new ApiInfoBuilder().title(title()).description(description()).termsOfServiceUrl("http://feixun.tv")
				.contact(creater()).build();
	}
}
