package com.jz.web.mvc.common.configuration;

import io.swagger.annotations.Api;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import org.springframework.web.bind.annotation.RequestMapping;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.io.ClassTools;

/**
 * @author 连杰
 */
public class DiscoverySwagger {

	public static List<String> discoveryMappingUrl(String... packages)
			throws IOException, ClassNotFoundException, URISyntaxException {
		List<URL> urls = ClassTools.findResourcesForPackage(packages);
		if (ArrayMapTools.isEmpty(urls))
			return null;
		List<URL> classUrls = getClassUrl(urls);
		List<String> resultUrls = Lists.newArrayList();
		for (URL url : classUrls) {
			Class<?> clazz = ClassTools.getClass(url);
			if (isWithAnnotation(clazz, Api.class) && isWithAnnotation(clazz, RequestMapping.class))
				resultUrls.addAll(getSwaggerUrls(clazz.getAnnotation(RequestMapping.class).value()));
		}
		return resultUrls;
	}

	private static List<URL> getClassUrl(List<URL> urls)
			throws ClassNotFoundException, IOException, URISyntaxException {
		List<URL> classUrls = Lists.newArrayList();
		for (URL url : urls) {
			if ("jar".equals(url.getProtocol()))
				classUrls.addAll(ClassTools.getClassUrlsForJar(url));
			else
				classUrls.addAll(ClassTools.getClassUrlsForFiles(url));
		}
		return classUrls;
	}

	private static boolean isWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
		return clazz.isAnnotationPresent(annotationClass);
	}

	private static final StringBuffer sb = new StringBuffer();

	private static List<String> getSwaggerUrls(String... values) {
		List<String> result = Lists.newArrayList();
		for (String val : values) {
			sb.delete(0, sb.length()).append(val);
			if (sb.indexOf("/") != 0)
				sb.insert(0, "/");
			if (sb.lastIndexOf("/") != sb.length() - 1)
				sb.append("/");
			sb.append(".*");
			result.add(sb.toString());
		}
		return result;
	}

}
