/*
 * Decompiled with CFR 0.152.
 */
package com.jz.service;

import com.jz.beans.AliyunClient;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oss.tables.pojos.SmsVerificationCode;
import com.jz.jooq.oss.tables.records.SmsVerificationCodeRecord;
import com.jz.oss.jar.service.SmsVerificationCodeService;
import com.jz.service.AliyunInvokeService;
import com.jz.sms.enums.Sign;
import com.jz.sms.response.SmsCommonResponse;
import java.util.Calendar;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsService {
    private static final Logger logger = LoggerFactory.getLogger(SmsService.class);
    private static final int usefulLifeMinute = 5;
    @Value(value="${aliyun.access.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.key.secret}")
    private String accessKeySecret;
    @Value(value="${aliyun.sms.template.code}")
    private String templateCode;
    @Value(value="${jz.environment}")
    private String env;
    @Autowired
    private SmsVerificationCodeService smsVerificationCodeService;

    public Pair<Boolean, String> sendCode(String phone, String app, Sign sign, String model) throws Exception {
        SmsVerificationCode code = this.smsVerificationCodeService.getValidCode(phone, app, model, System.currentTimeMillis());
        if (null != code) {
            if ((System.currentTimeMillis() - code.getLastSend()) / 1000L <= 60L) {
                return Pair.of((Object)false, (Object)"\u53d1\u9001\u592a\u8fc7\u9891\u7e41");
            }
            Pair<Boolean, String> result = this.invokeAliyun(phone, code.getCode(), sign);
            if (!((Boolean)result.getKey()).booleanValue()) {
                return result;
            }
            this.smsVerificationCodeService.updateLastSend(code.getId());
            return result;
        }
        String tempCode = StringTools.RandomString.numbers((int)6);
        Pair<Boolean, String> pair = this.invokeAliyun(phone, tempCode, sign);
        if (!((Boolean)pair.getKey()).booleanValue()) {
            return pair;
        }
        Calendar calendar = Calendar.getInstance();
        SmsVerificationCodeRecord codeRecord = new SmsVerificationCodeRecord();
        codeRecord.setPhone(phone);
        codeRecord.setApp(app);
        codeRecord.setModel(model);
        codeRecord.setCode(tempCode);
        codeRecord.setLastSend(Long.valueOf(calendar.getTimeInMillis()));
        codeRecord.setCreateTime(Long.valueOf(calendar.getTimeInMillis()));
        calendar.add(12, 5);
        codeRecord.setExpiry(Long.valueOf(calendar.getTimeInMillis()));
        this.smsVerificationCodeService.save(codeRecord);
        return pair;
    }

    private Pair<Boolean, String> invokeAliyun(String phone, String tempCode, Sign sign) throws Exception {
        AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, this.templateCode);
        aliyunClient.addTemplateParam("code", tempCode);
        String msg = AliyunInvokeService.sendSms(this.accessKeyId, this.accessKeySecret, aliyunClient);
        if (null == msg) {
            return Pair.of((Object)true, (Object)tempCode);
        }
        logger.error("[" + phone + "] send sms error : " + msg);
        return Pair.of((Object)false, (Object)msg);
    }

    public SmsCommonResponse checkCode(String phone, String code, String app, String model) {
        if ("test".equalsIgnoreCase(this.env) && "201808".equals(code)) {
            return SmsCommonResponse.ok();
        }
        long timeMillis = System.currentTimeMillis();
        SmsVerificationCode verificationCode = this.smsVerificationCodeService.getValidCode(phone, app, model, timeMillis);
        if (null == verificationCode) {
            return SmsCommonResponse.failed((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (verificationCode.getCode().equals(code)) {
            return SmsCommonResponse.ok();
        }
        return SmsCommonResponse.failed((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
    }
}

