/*
 * Decompiled with CFR 0.152.
 */
package com.jz.service;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oss.tables.pojos.SmsVerificationCode;
import com.jz.jooq.oss.tables.records.SmsVerificationCodeRecord;
import com.jz.oss.jar.service.SmsVerificationCodeService;
import com.jz.sms.response.SmsCommonResponse;
import java.util.Calendar;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsService {
    private static final Logger logger = LoggerFactory.getLogger(SmsService.class);
    private static final String product = "Dysmsapi";
    private static final String domain = "dysmsapi.aliyuncs.com";
    private static final String endpointName = "cn-beijing";
    private static final int usefulLifeMinute = 5;
    @Value(value="${aliyun.access.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.key.secret}")
    private String accessKeySecret;
    @Value(value="${aliyun.sms.template.code}")
    private String templateCode;
    @Value(value="${jz.environment}")
    private String env;
    @Autowired
    private SmsVerificationCodeService smsVerificationCodeService;

    public Pair<Boolean, String> sendCode(String phone) throws Exception {
        SmsVerificationCode code = this.smsVerificationCodeService.getValidCode(phone, System.currentTimeMillis());
        if (null != code) {
            return this.invokeAliyun(phone, code.getCode());
        }
        String tempCode = StringTools.RandomString.numbers((int)6);
        Pair<Boolean, String> pair = this.invokeAliyun(phone, tempCode);
        if (!((Boolean)pair.getKey()).booleanValue()) {
            return pair;
        }
        Calendar calendar = Calendar.getInstance();
        SmsVerificationCodeRecord codeRecord = new SmsVerificationCodeRecord();
        codeRecord.setPhone(phone);
        codeRecord.setCode(tempCode);
        codeRecord.setCreateTime(Long.valueOf(calendar.getTimeInMillis()));
        calendar.add(12, 5);
        codeRecord.setExpiry(Long.valueOf(calendar.getTimeInMillis()));
        this.smsVerificationCodeService.save(codeRecord);
        return pair;
    }

    private Pair<Boolean, String> invokeAliyun(String phone, String tempCode) throws Exception {
        String msg = this.sendSms(phone, this.getSignName(), tempCode, this.templateCode);
        if (null == msg) {
            return Pair.of((Object)true, (Object)tempCode);
        }
        logger.error("[" + phone + "] send sms error : " + msg);
        return Pair.of((Object)false, (Object)msg);
    }

    private String getSignName() {
        return "PlayABC";
    }

    private String sendSms(String phone, String signName, String code, String template) throws Exception {
        DefaultProfile profile = DefaultProfile.getProfile((String)endpointName, (String)this.accessKeyId, (String)this.accessKeySecret);
        DefaultProfile.addEndpoint((String)endpointName, (String)endpointName, (String)product, (String)domain);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setMethod(MethodType.POST);
        request.setPhoneNumbers(phone);
        request.setSignName(signName);
        request.setTemplateCode(template);
        request.setTemplateParam("{\"code\":\"" + code + "\"}");
        SendSmsResponse response = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        if (null == response) {
            return "\u7cfb\u7edf\u9519\u8bef";
        }
        if ("OK".equalsIgnoreCase(response.getCode())) {
            return null;
        }
        return response.getMessage();
    }

    public SmsCommonResponse checkCode(String phone, String code) {
        if ("test".equalsIgnoreCase(this.env) && "201808".equals(code)) {
            return SmsCommonResponse.ok();
        }
        long timeMillis = System.currentTimeMillis();
        SmsVerificationCode verificationCode = this.smsVerificationCodeService.getValidCode(phone, timeMillis);
        if (null == verificationCode) {
            return SmsCommonResponse.failed((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (verificationCode.getCode().equals(code)) {
            return SmsCommonResponse.ok();
        }
        return SmsCommonResponse.failed((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
    }
}

