package com.jz.config;

import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.jz.service.Core;
import com.jz.sms.enums.Sign;

/**
 * @Title SmsConfiguration
 * @Package com.jz.config
 * @author tangjunfeng
 * @date 2019年1月24日 下午4:46:39
 * @version V1.0
 */
@Component
public class SmsConfiguration {

	@Value("${aliyun.access.playabc.key.id}")
	private String accessKeyId;
	@Value("${aliyun.access.playabc.key.secret}")
	private String accessKeySecret;

	// 验证码
	@Value("${template.verification.code}")
	private String verificationCode;

	// 合同签署
	@Value("${template.contract}")
	private String contract;

	// 购买在线课通知
	@Value("${template.buy.pack}")
	private String buyPack;

	// 签单之后
	@Value("${template.contract.suc}")
	private String contractSuc;

	// 学员作品评价通知
	@Value("${template.works.suc}")
	private String worksSuc;

	// 试听预约成功通知
	@Value("${template.audition.suc}")
	private String auditionSuc;

	private static Table<Sign, String, GymchinaSmsAccess> sign2Access = HashBasedTable.create();

	@PostConstruct
	public void init() {
		Map<String, String> business2Code = Maps.newHashMap();
		business2Code.put(Core.verificationCode, verificationCode);
		business2Code.put(Core.contract, contract);
		business2Code.put(Core.buyPack, buyPack);
		business2Code.put(Core.contractSuc, contractSuc);
		business2Code.put(Core.worksSuc, worksSuc);
		business2Code.put(Core.auditionSuc, auditionSuc);

		putAccess(accessKeyId, accessKeySecret, "cn-beijing", business2Code, Sign.JingZhong, Sign.PlayABC, Sign.guanmei,
				Sign.tomato, Sign.touchbox, Sign.saixiansheng);
	}

	private void putAccess(String keyId, String keySecret, String endpointName, Map<String, String> b2code,
			Sign... signs) {
		b2code.forEach((bk, code) -> {
			GymchinaSmsAccess access = GymchinaSmsAccess.of(keyId, keySecret, code, endpointName);
			for (Sign sign : signs) {
				sign2Access.put(sign, bk, access);
			}
		});
	}

	public static GymchinaSmsAccess getAccessInfo(Sign sign, String bk) {
		return sign2Access.get(sign, bk);
	}
}
