/*
 * Decompiled with CFR 0.152.
 */
package com.jz.config;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.jz.config.GymchinaSmsAccess;
import com.jz.sms.enums.Sign;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SmsConfiguration {
    @Value(value="${aliyun.access.playabc.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.playabc.key.secret}")
    private String accessKeySecret;
    @Value(value="${template.verification.code}")
    private String verificationCode;
    @Value(value="${template.contract}")
    private String contract;
    @Value(value="${template.buy.pack}")
    private String buyPack;
    @Value(value="${template.contract.suc}")
    private String contractSuc;
    @Value(value="${template.works.suc}")
    private String worksSuc;
    @Value(value="${template.audition.suc}")
    private String auditionSuc;
    private static Table<Sign, String, GymchinaSmsAccess> sign2Access = HashBasedTable.create();

    @PostConstruct
    public void init() {
        HashMap business2Code = Maps.newHashMap();
        business2Code.put("verification.code", this.verificationCode);
        business2Code.put("contract", this.contract);
        business2Code.put("buy.pack", this.buyPack);
        business2Code.put("contract.suc", this.contractSuc);
        business2Code.put("works.suc", this.worksSuc);
        business2Code.put("audition.suc", this.auditionSuc);
        this.putAccess(this.accessKeyId, this.accessKeySecret, "cn-beijing", business2Code, Sign.JingZhong, Sign.PlayABC, Sign.guanmei, Sign.tomato, Sign.touchbox);
    }

    private void putAccess(String keyId, String keySecret, String endpointName, Map<String, String> b2code, Sign ... signs) {
        b2code.forEach((bk, code) -> {
            GymchinaSmsAccess access = GymchinaSmsAccess.of(keyId, keySecret, code, endpointName);
            for (Sign sign : signs) {
                sign2Access.put((Object)sign, bk, (Object)access);
            }
        });
    }

    public static GymchinaSmsAccess getAccessInfo(Sign sign, String bk) {
        return (GymchinaSmsAccess)sign2Access.get((Object)sign, (Object)bk);
    }
}

