package com.jz.service;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.jz.beans.AliyunClient;
import com.jz.config.GymchinaSmsAccess;
import com.jz.config.SmsConfiguration;
import com.jz.sms.enums.Sign;

@Service
public class SmsNoticeService {

	private static final Logger logger = LoggerFactory.getLogger(SmsNoticeService.class);

	public Pair<Boolean, String> sendContract(String phone, String schoolName, Sign sign) throws Exception {
		GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, Core.contract);
		if (null == accessInfo)
			return Pair.of(false, "无法获取账户信息");
		AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
		aliyunClient.addTemplateParam("school", sign.used + schoolName);
		aliyunClient.setEndpointName(accessInfo.getEndpointName());
		String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
		if (null == msg)
			return Pair.of(true, null);
		logger.error("[" + phone + "] send sms error : " + msg);
		return Pair.of(false, msg);
	}

	public Pair<Boolean, String> sendBuyPack(String phone, String name, Sign sign) throws Exception {
		GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, Core.buyPack);
		if (null == accessInfo)
			return Pair.of(false, "无法获取账户信息");
		AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
		aliyunClient.addTemplateParam("name", name);
		aliyunClient.setEndpointName(accessInfo.getEndpointName());
		String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
		if (null == msg)
			return Pair.of(true, null);
		logger.error("[" + phone + "] send sms error : " + msg);
		return Pair.of(false, msg);
	}

	public Pair<Boolean, String> sendContractSuc(String phone, String coin, Sign sign) throws Exception {
		GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, Core.contractSuc);
		if (null == accessInfo)
			return Pair.of(false, "无法获取账户信息");
		AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
		aliyunClient.addTemplateParam("coin", coin);
		aliyunClient.setEndpointName(accessInfo.getEndpointName());
		String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
		if (null == msg)
			return Pair.of(true, null);
		logger.error("[" + phone + "] send sms error : " + msg);
		return Pair.of(false, msg);
	}

	public Pair<Boolean, String> sendWorksSuc(String phone, Sign sign) throws Exception {
		GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, Core.worksSuc);
		if (null == accessInfo)
			return Pair.of(false, "无法获取账户信息");
		AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
		aliyunClient.setEndpointName(accessInfo.getEndpointName());
		String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
		if (null == msg)
			return Pair.of(true, null);
		logger.error("[" + phone + "] send sms error : " + msg);
		return Pair.of(false, msg);
	}

	public Pair<Boolean, String> sendAuditionSuc(String phone, String time, Sign sign) throws Exception {
		GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, Core.auditionSuc);
		if (null == accessInfo)
			return Pair.of(false, "无法获取账户信息");
		AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
		aliyunClient.addTemplateParam("time", time);
		aliyunClient.setEndpointName(accessInfo.getEndpointName());
		String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
		if (null == msg)
			return Pair.of(true, null);
		logger.error("[" + phone + "] send sms error : " + msg);
		return Pair.of(false, msg);
	}

}
