/*
 * Decompiled with CFR 0.152.
 */
package com.jz.config;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.jz.config.GymchinaSmsAccess;
import com.jz.sms.enums.Sign;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SmsConfiguration {
    @Value(value="${aliyun.access.playabc.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.playabc.key.secret}")
    private String accessKeySecret;
    @Value(value="${aliyun.sms.template.playabc.verification.code}")
    private String playabcTemplateCode;
    @Value(value="${aliyun.sms.template.playabc.contract}")
    private String playabcContract;
    private static Table<Sign, String, GymchinaSmsAccess> sign2Access = HashBasedTable.create();

    @PostConstruct
    public void init() {
        HashMap playabcB2code = Maps.newHashMap();
        playabcB2code.put("verification.code", this.playabcTemplateCode);
        playabcB2code.put("contract", this.playabcContract);
        this.putAccess(this.accessKeyId, this.accessKeySecret, "cn-beijing", playabcB2code, Sign.JingZhong, Sign.PlayABC, Sign.guanmei, Sign.tomato);
    }

    private void putAccess(String keyId, String keySecret, String endpointName, Map<String, String> b2code, Sign ... signs) {
        b2code.forEach((bk, code) -> {
            GymchinaSmsAccess access = GymchinaSmsAccess.of(keyId, keySecret, code, endpointName);
            for (Sign sign : signs) {
                sign2Access.put((Object)sign, bk, (Object)access);
            }
        });
    }

    public static GymchinaSmsAccess getAccessInfo(Sign sign, String bk) {
        return (GymchinaSmsAccess)sign2Access.get((Object)sign, (Object)bk);
    }
}

