package com.jz.service;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.jz.beans.AliyunClient;
import com.jz.common.utils.json.GsonTools;
import com.jz.sms.enums.Sign;

public class AliyunInvokeService {

	// aliyun短信API产品域名（接口地址固定，无需修改）
	private static final String product = "Dysmsapi", domain = "dysmsapi.aliyuncs.com";

	public static String sendSms(String accessKeyId, String secret, AliyunClient client) throws Exception {
		// 初始化ascClient,暂时不支持多region（请勿修改）
		IClientProfile profile = DefaultProfile.getProfile(client.getEndpointName(), accessKeyId, secret);
		DefaultProfile.addEndpoint(client.getEndpointName(), client.getEndpointName(), product, domain);
		IAcsClient acsClient = new DefaultAcsClient(profile);
		// 组装请求对象
		SendSmsRequest request = new SendSmsRequest();
		// 使用post提交
		request.setMethod(MethodType.POST);
		// 必填:待发送手机号。支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式；发送国际/港澳台消息时，接收号码格式为00+国际区号+号码，如“0085200000000”
		request.setPhoneNumbers(client.getPhone());
		// 必填:短信签名-可在短信控制台中找到
		request.setSignName(client.getSignName());
		// 必填:短信模板-可在短信控制台中找到，发送国际/港澳台消息时，请使用国际/港澳台短信模版
		request.setTemplateCode(client.getTemplate());
		// 可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为
		// 友情提示:如果JSON中需要带换行符,请参照标准的JSON协议对换行符的要求,比如短信内容中包含\r\n的情况在JSON中需要表示成\\r\\n,否则会导致JSON在服务端解析失败
		if (null != client.getTemplateParams())
			request.setTemplateParam(GsonTools.gson.toJson(client.getTemplateParams()));
		// 可选-上行短信扩展码(扩展码字段控制在7位或以下，无特殊需求用户请忽略此字段)
		// request.setSmsUpExtendCode("90997");
		// 可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
		// request.setOutId("yourOutId");
		// 请求失败这里会抛ClientException异常
		SendSmsResponse response = acsClient.getAcsResponse(request);
		if (null == response)
			return "系统错误";
		if ("OK".equalsIgnoreCase(response.getCode())) {
			return null;
		}
		return response.getMessage();
	}
	
	public static void main(String[] args) {
		AliyunClient aliyunClient = AliyunClient.of("18810815309", Sign.tomato.used, "SMS_67900148");
		aliyunClient.addTemplateParam("code", "998909");
		aliyunClient.addTemplateParam("product", Sign.tomato.used);
		aliyunClient.setEndpointName("cn-shanghai");
		try {
			String msg = AliyunInvokeService.sendSms("LTAISAnuC5Ls15RU", "pL5tHwdEiGsYNANgIFQQMUjTmfh42j", aliyunClient);
			System.out.println(msg);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
