/*
 * Decompiled with CFR 0.152.
 */
package com.jz.service;

import com.jz.beans.AliyunClient;
import com.jz.config.GymchinaSmsAccess;
import com.jz.config.SmsConfiguration;
import com.jz.service.AliyunInvokeService;
import com.jz.sms.enums.Sign;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsContractService {
    private static final Logger logger = LoggerFactory.getLogger(SmsContractService.class);

    public Pair<Boolean, String> sendContractNotice(String phone, String schoolName, Sign sign) throws Exception {
        GymchinaSmsAccess accessInfo = SmsConfiguration.getAccessInfo(sign, "contract");
        if (null == accessInfo) {
            return Pair.of((Object)false, (Object)"\u65e0\u6cd5\u83b7\u53d6\u8d26\u6237\u4fe1\u606f");
        }
        AliyunClient aliyunClient = AliyunClient.of(phone, sign.used, accessInfo.getTemplateCode());
        aliyunClient.addTemplateParam("school", sign.used + schoolName);
        aliyunClient.setEndpointName(accessInfo.getEndpointName());
        String msg = AliyunInvokeService.sendSms(accessInfo.getKeyId(), accessInfo.getKeySecret(), aliyunClient);
        if (null == msg) {
            return Pair.of((Object)true, null);
        }
        logger.error("[" + phone + "] send sms error : " + msg);
        return Pair.of((Object)false, (Object)msg);
    }
}

