/*
 * Decompiled with CFR 0.152.
 */
package com.jz.sms;

import com.google.common.collect.Maps;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.sms.response.SmsCommonResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsClient {
    @Value(value="${jz.sms.server.send.url}")
    private String SMS_SEND;
    @Value(value="${jz.sms.server.check.url}")
    private String SMS_CHECK;
    private static SmsClient client;

    private SmsClient() {
        client = this;
    }

    private SmsClient(String send, String check) {
        this.SMS_SEND = send;
        this.SMS_CHECK = check;
    }

    public static SmsClient getClient() {
        return new SmsClient(SmsClient.client.SMS_SEND, SmsClient.client.SMS_CHECK);
    }

    public boolean sendCode(String phone, String app) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("app", app);
        String result = ConnectPost.send((String)this.SMS_SEND, (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return false;
        }
        SmsCommonResponse response = (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
        return response.isSuccess();
    }

    public SmsCommonResponse checkCode(String phone, String code, String app) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("code", code);
        params.put("app", app);
        String result = ConnectPost.send((String)this.SMS_CHECK, (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }
}

