package com.jz.sms;

import java.io.IOException;
import java.util.Map;

import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.sms.enums.Sign;
import com.jz.sms.response.SmsCommonResponse;

@Service
public class GymSmsClient {

	@Value("${gymchina.sms.server.url}")
	private String server;

	private static GymSmsClient client;

	private GymSmsClient() {
		client = this;
	}

	private GymSmsClient(String server) {
		if (!server.endsWith("/"))
			server += "/";
		this.server = server;
	}

	public static GymSmsClient getClient() {
		return getClient(client.server);
	}

	public static GymSmsClient getClient(String server) {
		return new GymSmsClient(server);
	}

	/** 发送短信 */
	public boolean sendCode(String phone, String app, Sign sign) throws ClientProtocolException, IOException {
		return this.sendCode(phone, app, null, sign);
	}

	/** 发送短信 */
	public boolean sendCode(String phone, String app, String model, Sign sign) throws ClientProtocolException,
			IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("app", app);
		params.put("sign", sign.name());
		if (null != model)
			params.put("model", model);
		// 发送post
		String result = ConnectPost.send(server + "code/send", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return false;
		SmsCommonResponse response = GsonTools.gson.fromJson(result, SmsCommonResponse.class);
		return response.isSuccess();
	}

	/** 验证码 */
	public SmsCommonResponse checkCode(String phone, String code, String app) throws ClientProtocolException,
			IOException {
		return this.checkCode(phone, code, app, null);
	}

	/** 验证码 */
	public SmsCommonResponse checkCode(String phone, String code, String app, String model)
			throws ClientProtocolException, IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("code", code);
		params.put("app", app);
		if (null != model)
			params.put("model", model);
		// 发送post
		String result = ConnectPost.send(server + "code/check", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}

	/** 合同签署 */
	public SmsCommonResponse contractNotice(String phone, String schoolName, Sign sign) throws ClientProtocolException,
			IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("schoolName", schoolName);
		params.put("sign", sign.name());
		// 发送post
		String result = ConnectPost.send(server + "notice/contract", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}

	/** 购买在线课通知 */
	public SmsCommonResponse buyPack(String phone, String name, Sign sign) throws ClientProtocolException, IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("name", name);
		params.put("sign", sign.name());
		// 发送post
		String result = ConnectPost.send(server + "notice/buyPack", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}

	/** 签单之后 */
	public SmsCommonResponse contractSuc(String phone, Sign sign) throws ClientProtocolException, IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("sign", sign.name());
		// 发送post
		String result = ConnectPost.send(server + "notice/contractSuc", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}

	/** 学员作品评价通知 */
	public SmsCommonResponse worksSuc(String phone, Sign sign) throws ClientProtocolException, IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("sign", sign.name());
		// 发送post
		String result = ConnectPost.send(server + "notice/worksSuc", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}

	/** 试听预约成功通知 */
	public SmsCommonResponse auditionSuc(String phone, String time, Sign sign) throws ClientProtocolException,
			IOException {
		Map<String, String> params = Maps.newHashMap();
		params.put("phone", phone);
		params.put("time", time);
		params.put("sign", sign.name());
		// 发送post
		String result = ConnectPost.send(server + "notice/auditionSuc", params, "UTF-8");
		if (StringTools.isEmptyAndBlank(result))
			return null;
		return GsonTools.gson.fromJson(result, SmsCommonResponse.class);
	}

}