/*
 * Decompiled with CFR 0.152.
 */
package com.jz.sms;

import com.google.common.collect.Maps;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.sms.enums.Sign;
import com.jz.sms.response.SmsCommonResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GymSmsClient {
    @Value(value="${gymchina.sms.server.url}")
    private String server;
    private static GymSmsClient client;

    private GymSmsClient() {
        client = this;
    }

    private GymSmsClient(String server) {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        this.server = server;
    }

    public static GymSmsClient getClient() {
        return GymSmsClient.getClient(GymSmsClient.client.server);
    }

    public static GymSmsClient getClient(String server) {
        return new GymSmsClient(server);
    }

    public boolean sendCode(String phone, String app, Sign sign) throws ClientProtocolException, IOException {
        return this.sendCode(phone, app, null, sign);
    }

    public boolean sendCode(String phone, String app, String model, Sign sign) throws ClientProtocolException, IOException {
        String result;
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("app", app);
        params.put("sign", sign.name());
        if (null != model) {
            params.put("model", model);
        }
        if (StringTools.isEmptyAndBlank((String)(result = ConnectPost.send((String)(this.server + "code/send"), (Map)params, (String)"UTF-8")))) {
            return false;
        }
        SmsCommonResponse response = (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
        return response.isSuccess();
    }

    public SmsCommonResponse checkCode(String phone, String code, String app) throws ClientProtocolException, IOException {
        return this.checkCode(phone, code, app, null);
    }

    public SmsCommonResponse checkCode(String phone, String code, String app, String model) throws ClientProtocolException, IOException {
        String result;
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("code", code);
        params.put("app", app);
        if (null != model) {
            params.put("model", model);
        }
        if (StringTools.isEmptyAndBlank((String)(result = ConnectPost.send((String)(this.server + "code/check"), (Map)params, (String)"UTF-8")))) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }

    public SmsCommonResponse contractNotice(String phone, String schoolName, Sign sign) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("schoolName", schoolName);
        params.put("sign", sign.name());
        String result = ConnectPost.send((String)(this.server + "notice/contract"), (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }

    public SmsCommonResponse buyPack(String phone, String name, Sign sign) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("name", name);
        params.put("sign", sign.name());
        String result = ConnectPost.send((String)(this.server + "notice/buyPack"), (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }

    public SmsCommonResponse contractSuc(String phone, String coin, Sign sign) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("coin", coin);
        params.put("sign", sign.name());
        String result = ConnectPost.send((String)(this.server + "notice/contractSuc"), (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }

    public SmsCommonResponse worksSuc(String phone, Sign sign) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("sign", sign.name());
        String result = ConnectPost.send((String)(this.server + "notice/worksSuc"), (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }

    public SmsCommonResponse auditionSuc(String phone, String time, Sign sign) throws ClientProtocolException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("phone", phone);
        params.put("time", time);
        params.put("sign", sign.name());
        String result = ConnectPost.send((String)(this.server + "notice/auditionSuc"), (Map)params, (String)"UTF-8");
        if (StringTools.isEmptyAndBlank((String)result)) {
            return null;
        }
        return (SmsCommonResponse)GsonTools.gson.fromJson(result, SmsCommonResponse.class);
    }
}

