package com.jz.shop.jar.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.shop.tables.pojos.Supplier;
import com.jz.shop.jar.repository.SupplierRepository;

@Lazy
@Repository
public class SupplierService {

	@Autowired
	private SupplierRepository supplierRepository;

	public Supplier getSupplier(String supplierId) {
		return supplierRepository.getSupplier(supplierId);
	}

	public Map<String, Supplier> mutiGetSupplier(Collection<String> supplierIds) {
		List<Supplier> suppliers = supplierRepository.mutiGetSupplier(supplierIds);
		if (ArrayMapTools.isEmpty(suppliers)) {
			return null;
		}
		Map<String, Supplier> rsMap = Maps.newHashMap();
		suppliers.forEach(it -> rsMap.put(it.getId(), it));
		return rsMap;
	}

	public int cntSupplier(String type, String keyword) {
		return supplierRepository.cntSupplier(type, keyword);
	}

	public List<Supplier> listSupplier(String type, String keyword, int start, int size) {
		return supplierRepository.listSupplier(type, keyword, start, size);
	}

	public void createSupplier(String id, String name, String type, String remark) {
		supplierRepository.createSupplier(id, name, type, remark);
	}

	public void editSupplier(String id, String name, String type, String remark) {
		supplierRepository.editSupplier(id, name, type, remark);
	}

	public void updateSupplierStatus(String id, int status) {
		supplierRepository.updateSupplierStatus(id, status);
	}

}
