/*
 * Decompiled with CFR 0.152.
 */
package com.jz.shop.jar.repository;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.GoodsWarehouseStock;
import com.jz.jooq.shop.tables.records.GoodsWarehouseStockRecord;
import com.jz.shop.jar.repository.ShopBaseRepository;
import com.jz.shop.jar.wrapper.GoodsStock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class GoodsWarehouseStockRepository
extends ShopBaseRepository {
    private static final GoodsWarehouseStock S = Tables.GOODS_WAREHOUSE_STOCK;

    public Table<String, String, Integer> mutiGetGoodsWarehouseNum(Map<String, String> goodsId2WarehouseId) {
        String sql = "SELECT `goods_id`,`warehouse_id`,`real_stock` FROM `goods_warehouse_stock`  WHERE `goods_id` = ? AND `warehouse_id` = ? ";
        ArrayList batchArgs = Lists.newArrayList();
        goodsId2WarehouseId.forEach((goodsId, warehouseId) -> batchArgs.add(new Object[]{goodsId, warehouseId}));
        List list = this.oaJdbcTemplate.query(sql, batchArgs.toArray(), (RowMapper)new BeanPropertyRowMapper(GoodsStock.class));
        if (ArrayMapTools.isEmpty((Collection)list)) {
            return null;
        }
        HashBasedTable rsTable = HashBasedTable.create();
        list.forEach(arg_0 -> GoodsWarehouseStockRepository.lambda$mutiGetGoodsWarehouseNum$2((Table)rsTable, arg_0));
        return rsTable;
    }

    public void insertUpdateGoodsStock(Collection<GoodsWarehouseStockRecord> stockUpdateRecords, List<GoodsWarehouseStockRecord> stockInsertRecords) {
        this.shopCtx.batchInsert(stockInsertRecords).execute();
        this.shopCtx.batchUpdate(stockUpdateRecords).execute();
    }

    private static /* synthetic */ void lambda$mutiGetGoodsWarehouseNum$2(Table table, GoodsStock it) {
        table.put((Object)it.getGoodsId(), (Object)it.getWarehourseId(), (Object)it.getRealStock());
    }
}

