package com.jz.shop.jar.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Repository;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.records.GoodsWarehouseStockRecord;
import com.jz.shop.jar.wrapper.GoodsStock;

@Lazy
@Repository
public class GoodsWarehouseStockRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.GoodsWarehouseStock S = Tables.GOODS_WAREHOUSE_STOCK;

	public Table<String, String, Integer> mutiGetGoodsWarehouseNum(Map<String, String> goodsId2WarehouseId) {
		String sql = "SELECT `goods_id`,`warehouse_id`,`real_stock` FROM `goods_warehouse_stock`  WHERE `goods_id` = ? AND `warehouse_id` = ? ";
		List<Object[]> batchArgs = Lists.newArrayList();
		goodsId2WarehouseId.forEach((goodsId, warehouseId) -> {
			batchArgs.add(new Object[] { goodsId, warehouseId });
		});
		List<GoodsStock> list = oaJdbcTemplate.query(sql, batchArgs.toArray(),
				new BeanPropertyRowMapper<GoodsStock>(GoodsStock.class));
		if (ArrayMapTools.isEmpty(list)) {
			return null;
		}
		Table<String, String, Integer> rsTable = HashBasedTable.create();
		list.forEach(it -> {
			rsTable.put(it.getGoodsId(), it.getWarehourseId(), it.getRealStock());
		});
		return rsTable;
	}

	public void insertUpdateGoodsStock(Collection<GoodsWarehouseStockRecord> stockUpdateRecords,
			List<GoodsWarehouseStockRecord> stockInsertRecords) {
		shopCtx.batchInsert(stockInsertRecords).execute();
		shopCtx.batchUpdate(stockUpdateRecords).execute();
	}

}
