package com.jz.shop.jar.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.pojos.Supplier;

@Lazy
@Repository
public class SupplierRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.Supplier S = Tables.SUPPLIER;

	public Supplier getSupplier(String supplierId) {
		return shopCtx.selectFrom(S).where(S.ID.eq(supplierId)).fetchAnyInto(Supplier.class);
	}

	public List<Supplier> mutiGetSupplier(Collection<String> supplierIds) {
		return shopCtx.selectFrom(S).where(S.ID.in(supplierIds)).fetchInto(Supplier.class);
	}

}
