package com.jz.shop.jar.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.pojos.Promote;
import com.jz.jooq.shop.tables.pojos.PromoteGoods;

@Lazy
@Repository
public class PromoteRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.Promote P = Tables.PROMOTE;
	private static final com.jz.jooq.shop.tables.PromoteGoods PG = Tables.PROMOTE_GOODS;

	public Promote getPromote(int promoteId, String productId) {
		return shopCtx.selectFrom(P).where(P.ID.eq(promoteId).and(P.PRODUCT_ID.eq(productId)))
				.fetchAnyInto(Promote.class);
	}

	public List<PromoteGoods> getPromoteGoods(int promoteId, String productId) {
		return shopCtx.selectFrom(PG).where(PG.PROMOTE_ID.eq(promoteId).and(PG.PRODUCT_ID.eq(productId)))
				.fetchInto(PromoteGoods.class);
	}

	public Promote getCurrentPromote(String productId) {
		long current = System.currentTimeMillis();
		return shopCtx.selectFrom(P)
				.where(P.PRODUCT_ID.eq(productId).and(P.START_TIME.lt(current)).and(P.END_TIME.gt(current)))
				.orderBy(P.ID.desc()).limit(1).fetchAnyInto(Promote.class);
	}

}
