package com.jz.shop.jar.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.pojos.Product;
import com.jz.jooq.shop.tables.pojos.ProductGoods;

@Lazy
@Repository
public class ProductRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.Product P = Tables.PRODUCT;
	private static final com.jz.jooq.shop.tables.ProductGoods PG = Tables.PRODUCT_GOODS;

	public Product getProduct(String productId) {
		return shopCtx.selectFrom(P).where(P.ID.eq(productId)).fetchAnyInto(Product.class);
	}

	public List<ProductGoods> getProductGoods(String productId) {
		return shopCtx.selectFrom(PG).where(PG.PRODUCT_ID.eq(productId)).orderBy(PG.SEQ.asc())
				.fetchInto(ProductGoods.class);
	}

}
