package com.jz.shop.jar.repository;

import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

class ShopBaseRepository {

	static final Logger logger = LoggerFactory.getLogger(ShopBaseRepository.class);

	/** franchise库 */
	@Lazy
	@Autowired
	@Qualifier("franchiseCtx")
	DSLContext franchiseCtx;

	@Lazy
	@Autowired
	@Qualifier("franchiseJdbcTemplate")
	JdbcTemplate franchiseJdbcTemplate;

	/** oa库 */
	@Lazy
	@Autowired
	@Qualifier("oaCtx")
	DSLContext oaCtx;

	@Lazy
	@Autowired
	@Qualifier("oaJdbcTemplate")
	JdbcTemplate oaJdbcTemplate;

	@Lazy
	@Autowired
	@Qualifier("oaNamedParameterJdbcTemplate")
	NamedParameterJdbcTemplate oaNamedParameterJdbcTemplate;

	/** shop库 */
	@Lazy
	@Autowired
	@Qualifier("shopCtx")
	DSLContext shopCtx;

	@Lazy
	@Autowired
	@Qualifier("shopJdbcTemplate")
	JdbcTemplate shopJdbcTemplate;

	@Lazy
	@Autowired
	@Qualifier("shopNamedParameterJdbcTemplate")
	NamedParameterJdbcTemplate shopNamedParameterJdbcTemplate;

}
