/*
 * Decompiled with CFR 0.152.
 */
package com.jz.shop.jar.repository;

import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.Supplier;
import com.jz.jooq.shop.tables.records.SupplierRecord;
import com.jz.shop.jar.repository.ShopBaseRepository;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class SupplierRepository
extends ShopBaseRepository {
    private static final Supplier S = Tables.SUPPLIER;

    public com.jz.jooq.shop.tables.pojos.Supplier getSupplier(String supplierId) {
        return (com.jz.jooq.shop.tables.pojos.Supplier)this.shopCtx.selectFrom((Table)S).where(new Condition[]{SupplierRepository.S.ID.eq((Object)supplierId)}).fetchAnyInto(com.jz.jooq.shop.tables.pojos.Supplier.class);
    }

    public List<com.jz.jooq.shop.tables.pojos.Supplier> mutiGetSupplier(Collection<String> supplierIds) {
        return this.shopCtx.selectFrom((Table)S).where(new Condition[]{SupplierRepository.S.ID.in(supplierIds)}).fetchInto(com.jz.jooq.shop.tables.pojos.Supplier.class);
    }

    public int cntSupplier(String type, String keyword) {
        return this.shopCtx.fetchCount((Table)S, this.filterCondition(type, keyword));
    }

    private Condition filterCondition(String type, String keyword) {
        Condition condition = SupplierRepository.S.STATUS.ne((Object)-1);
        if (type != null) {
            condition = condition.and(SupplierRepository.S.TYPE.eq((Object)type));
        }
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(SupplierRepository.S.NAME.like("%" + keyword + "%"));
        }
        return condition;
    }

    public List<com.jz.jooq.shop.tables.pojos.Supplier> listSupplier(String type, String keyword, int start, int size) {
        return this.shopCtx.selectFrom((Table)S).where(new Condition[]{this.filterCondition(type, keyword)}).orderBy(SupplierRepository.S.CREATE_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.shop.tables.pojos.Supplier.class);
    }

    public List<com.jz.jooq.shop.tables.pojos.Supplier> listOnlineSupplier() {
        return this.shopCtx.selectFrom((Table)S).where(new Condition[]{SupplierRepository.S.STATUS.eq((Object)1)}).orderBy(SupplierRepository.S.CREATE_TIME.desc()).fetchInto(com.jz.jooq.shop.tables.pojos.Supplier.class);
    }

    public void createSupplier(String id, String name, String type, Double taxRatio, String remark) {
        SupplierRecord record = new SupplierRecord();
        record.setId(id);
        record.setName(name);
        record.setType(type);
        record.setTaxRatio(new BigDecimal(taxRatio));
        record.setRemark(remark);
        record.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        this.shopCtx.insertInto((Table)S).set((Record)record).execute();
    }

    public void editSupplier(String id, String name, String type, Double taxRatio, String remark) {
        this.shopCtx.update((Table)S).set((Field)SupplierRepository.S.NAME, (Object)name).set((Field)SupplierRepository.S.TYPE, (Object)type).set((Field)SupplierRepository.S.TAX_RATIO, (Object)new BigDecimal(taxRatio)).set((Field)SupplierRepository.S.REMARK, (Object)remark).where(new Condition[]{SupplierRepository.S.ID.eq((Object)id)}).execute();
    }

    public void updateSupplierStatus(String id, int status) {
        this.shopCtx.update((Table)S).set((Field)SupplierRepository.S.STATUS, (Object)status).where(new Condition[]{SupplierRepository.S.ID.eq((Object)id)}).execute();
    }
}

