package com.jz.shop.jar.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.shop.Tables;
import com.jz.jooq.shop.tables.pojos.Supplier;
import com.jz.jooq.shop.tables.records.SupplierRecord;

@Lazy
@Repository
public class SupplierRepository extends ShopBaseRepository {

	private static final com.jz.jooq.shop.tables.Supplier S = Tables.SUPPLIER;

	public Supplier getSupplier(String supplierId) {
		return shopCtx.selectFrom(S).where(S.ID.eq(supplierId)).fetchAnyInto(Supplier.class);
	}

	public List<Supplier> mutiGetSupplier(Collection<String> supplierIds) {
		return shopCtx.selectFrom(S).where(S.ID.in(supplierIds)).fetchInto(Supplier.class);
	}

	public int cntSupplier(String type, String keyword) {
		return shopCtx.fetchCount(S, this.filterCondition(type, keyword));
	}

	private Condition filterCondition(String type, String keyword) {
		Condition condition = S.STATUS.ne(-1);
		if (type != null) {
			condition = condition.and(S.TYPE.eq(type));
		}
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(S.NAME.like("%" + keyword + "%"));
		}
		return condition;
	}

	public List<Supplier> listSupplier(String type, String keyword, int start, int size) {
		return shopCtx.selectFrom(S).where(this.filterCondition(type, keyword)).orderBy(S.CREATE_TIME.desc())
				.limit(start, size).fetchInto(Supplier.class);
	}

	public List<Supplier> listOnlineSupplier() {
		return shopCtx.selectFrom(S).where(S.STATUS.eq(1)).orderBy(S.CREATE_TIME.desc()).fetchInto(Supplier.class);
	}

	public void createSupplier(String id, String name, String type, Double taxRatio, String remark) {
		SupplierRecord record = new SupplierRecord();
		record.setId(id);
		record.setName(name);
		record.setType(type);
		record.setTaxRatio(new BigDecimal(taxRatio));
		record.setRemark(remark);
		record.setCreateTime(System.currentTimeMillis());
		shopCtx.insertInto(S).set(record).execute();
	}

	public void editSupplier(String id, String name, String type, Double taxRatio, String remark) {
		shopCtx.update(S).set(S.NAME, name).set(S.TYPE, type).set(S.TAX_RATIO, new BigDecimal(taxRatio))
				.set(S.REMARK, remark).where(S.ID.eq(id)).execute();
	}

	public void updateSupplierStatus(String id, int status) {
		shopCtx.update(S).set(S.STATUS, status).where(S.ID.eq(id)).execute();
	}

}
