/**
 * This class is generated by jOOQ
 */
package com.jz.jooq.shop.tables;


import com.jz.jooq.shop.Keys;
import com.jz.jooq.shop.Shop;
import com.jz.jooq.shop.tables.records.ProductRecord;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

import javax.annotation.Generated;

import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.TableImpl;


/**
 * 产品信息表
 */
@Generated(
	value = {
		"http://www.jooq.org",
		"jOOQ version:3.6.2"
	},
	comments = "This class is generated by jOOQ"
)
@SuppressWarnings({ "all", "unchecked", "rawtypes" })
public class Product extends TableImpl<ProductRecord> {

	private static final long serialVersionUID = -385622916;

	/**
	 * The reference instance of <code>shop.product</code>
	 */
	public static final Product PRODUCT = new Product();

	/**
	 * The class holding records for this type
	 */
	@Override
	public Class<ProductRecord> getRecordType() {
		return ProductRecord.class;
	}

	/**
	 * The column <code>shop.product.id</code>. 商品id
	 */
	public final TableField<ProductRecord, String> ID = createField("id", org.jooq.impl.SQLDataType.VARCHAR.length(32).nullable(false), this, "商品id");

	/**
	 * The column <code>shop.product.name</code>. 商品名称
	 */
	public final TableField<ProductRecord, String> NAME = createField("name", org.jooq.impl.SQLDataType.VARCHAR.length(64).nullable(false), this, "商品名称");

	/**
	 * The column <code>shop.product.product_type_id</code>. 商品类型，蕃茄田playabc Arkky
	 */
	public final TableField<ProductRecord, String> PRODUCT_TYPE_ID = createField("product_type_id", org.jooq.impl.SQLDataType.VARCHAR.length(32).nullable(false), this, "商品类型，蕃茄田playabc Arkky");

	/**
	 * The column <code>shop.product.sale_type</code>. 1单品上架 2打包上架
	 */
	public final TableField<ProductRecord, Integer> SALE_TYPE = createField("sale_type", org.jooq.impl.SQLDataType.INTEGER.nullable(false), this, "1单品上架 2打包上架");

	/**
	 * The column <code>shop.product.freight_type</code>. 1邮费到付 2满多少件包邮 3到付不参与包邮
	 */
	public final TableField<ProductRecord, Integer> FREIGHT_TYPE = createField("freight_type", org.jooq.impl.SQLDataType.INTEGER.nullable(false), this, "1邮费到付 2满多少件包邮 3到付不参与包邮");

	/**
	 * The column <code>shop.product.freight_free_threshold</code>. 满多少件包邮阈值
	 */
	public final TableField<ProductRecord, Integer> FREIGHT_FREE_THRESHOLD = createField("freight_free_threshold", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "满多少件包邮阈值");

	/**
	 * The column <code>shop.product.thumbnails</code>. 缩略图
	 */
	public final TableField<ProductRecord, String> THUMBNAILS = createField("thumbnails", org.jooq.impl.SQLDataType.VARCHAR.length(2048), this, "缩略图");

	/**
	 * The column <code>shop.product.detail_pics</code>. 详情图
	 */
	public final TableField<ProductRecord, String> DETAIL_PICS = createField("detail_pics", org.jooq.impl.SQLDataType.VARCHAR.length(2048), this, "详情图");

	/**
	 * The column <code>shop.product.remark</code>. 产品描述
	 */
	public final TableField<ProductRecord, String> REMARK = createField("remark", org.jooq.impl.SQLDataType.VARCHAR.length(2048), this, "产品描述");

	/**
	 * The column <code>shop.product.book_type</code>. 1普通 2预售
	 */
	public final TableField<ProductRecord, Integer> BOOK_TYPE = createField("book_type", org.jooq.impl.SQLDataType.INTEGER.nullable(false), this, "1普通 2预售");

	/**
	 * The column <code>shop.product.book_start_time</code>. 预售开始时间
	 */
	public final TableField<ProductRecord, Long> BOOK_START_TIME = createField("book_start_time", org.jooq.impl.SQLDataType.BIGINT, this, "预售开始时间");

	/**
	 * The column <code>shop.product.book_end_time</code>. 预售结束时间
	 */
	public final TableField<ProductRecord, Long> BOOK_END_TIME = createField("book_end_time", org.jooq.impl.SQLDataType.BIGINT, this, "预售结束时间");

	/**
	 * The column <code>shop.product.money</code>. 打包上架的金额 如果是单品上架，就存最小金额
	 */
	public final TableField<ProductRecord, BigDecimal> MONEY = createField("money", org.jooq.impl.SQLDataType.DECIMAL.precision(13, 2).nullable(false), this, "打包上架的金额 如果是单品上架，就存最小金额");

	/**
	 * The column <code>shop.product.origin_money</code>. 打包上架的原价金额 如果是单品上架，就存最小原价金额
	 */
	public final TableField<ProductRecord, BigDecimal> ORIGIN_MONEY = createField("origin_money", org.jooq.impl.SQLDataType.DECIMAL.precision(13, 2), this, "打包上架的原价金额 如果是单品上架，就存最小原价金额");

	/**
	 * The column <code>shop.product.status</code>. 1上架 2下架
	 */
	public final TableField<ProductRecord, Integer> STATUS = createField("status", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "1上架 2下架");

	/**
	 * The column <code>shop.product.recom_weight</code>. 推荐权重 0不推荐 权重倒排
	 */
	public final TableField<ProductRecord, Integer> RECOM_WEIGHT = createField("recom_weight", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "推荐权重 0不推荐 权重倒排");

	/**
	 * The column <code>shop.product.create_time</code>. 添加时间
	 */
	public final TableField<ProductRecord, Long> CREATE_TIME = createField("create_time", org.jooq.impl.SQLDataType.BIGINT.nullable(false), this, "添加时间");

	/**
	 * The column <code>shop.product.is_ho</code>. 是否只有总部物流部能找到这个
	 */
	public final TableField<ProductRecord, Integer> IS_HO = createField("is_ho", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "是否只有总部物流部能找到这个");

	/**
	 * The column <code>shop.product.lf_tip</code>. 给利丰仓的备注
	 */
	public final TableField<ProductRecord, String> LF_TIP = createField("lf_tip", org.jooq.impl.SQLDataType.VARCHAR.length(256), this, "给利丰仓的备注");

	/**
	 * The column <code>shop.product.is_open_period</code>. 开业期购买
	 */
	public final TableField<ProductRecord, Integer> IS_OPEN_PERIOD = createField("is_open_period", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "开业期购买");

	/**
	 * The column <code>shop.product.c_app</code>. 是否是c端用
	 */
	public final TableField<ProductRecord, Integer> C_APP = createField("c_app", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "是否是c端用");

	/**
	 * The column <code>shop.product.have_pack</code>. 是否有课包 1有蕃茄田课包 2有playabc课包
	 */
	public final TableField<ProductRecord, Integer> HAVE_PACK = createField("have_pack", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "是否有课包 1有蕃茄田课包 2有playabc课包");

	/**
	 * The column <code>shop.product.allow_distribute</code>. 是否允许分销
	 */
	public final TableField<ProductRecord, Integer> ALLOW_DISTRIBUTE = createField("allow_distribute", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "是否允许分销");

	/**
	 * The column <code>shop.product.distribute_first_per</code>. 1级分销比例
	 */
	public final TableField<ProductRecord, Integer> DISTRIBUTE_FIRST_PER = createField("distribute_first_per", org.jooq.impl.SQLDataType.INTEGER, this, "1级分销比例");

	/**
	 * The column <code>shop.product.distribute_second_per</code>. 2级分销比例
	 */
	public final TableField<ProductRecord, Integer> DISTRIBUTE_SECOND_PER = createField("distribute_second_per", org.jooq.impl.SQLDataType.INTEGER, this, "2级分销比例");

	/**
	 * The column <code>shop.product.c_forbid</code>. c端是否屏蔽
	 */
	public final TableField<ProductRecord, Integer> C_FORBID = createField("c_forbid", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "c端是否屏蔽");

	/**
	 * The column <code>shop.product.pack_only</code>. 是否只有在线课包，这样可以不填写收货地址
	 */
	public final TableField<ProductRecord, Integer> PACK_ONLY = createField("pack_only", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "是否只有在线课包，这样可以不填写收货地址");

	/**
	 * The column <code>shop.product.distribute_pics</code>. 分销海报图片
	 */
	public final TableField<ProductRecord, String> DISTRIBUTE_PICS = createField("distribute_pics", org.jooq.impl.SQLDataType.VARCHAR.length(1024), this, "分销海报图片");

	/**
	 * The column <code>shop.product.finish_pic</code>. 报名成功页面二维码
	 */
	public final TableField<ProductRecord, String> FINISH_PIC = createField("finish_pic", org.jooq.impl.SQLDataType.VARCHAR.length(64), this, "报名成功页面二维码");

	/**
	 * The column <code>shop.product.finish_remark</code>. 报名成功页面二维码文案
	 */
	public final TableField<ProductRecord, String> FINISH_REMARK = createField("finish_remark", org.jooq.impl.SQLDataType.VARCHAR.length(64), this, "报名成功页面二维码文案");

	/**
	 * Create a <code>shop.product</code> table reference
	 */
	public Product() {
		this("product", null);
	}

	/**
	 * Create an aliased <code>shop.product</code> table reference
	 */
	public Product(String alias) {
		this(alias, PRODUCT);
	}

	private Product(String alias, Table<ProductRecord> aliased) {
		this(alias, aliased, null);
	}

	private Product(String alias, Table<ProductRecord> aliased, Field<?>[] parameters) {
		super(alias, Shop.SHOP, aliased, parameters, "产品信息表");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UniqueKey<ProductRecord> getPrimaryKey() {
		return Keys.KEY_PRODUCT_PRIMARY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<UniqueKey<ProductRecord>> getKeys() {
		return Arrays.<UniqueKey<ProductRecord>>asList(Keys.KEY_PRODUCT_PRIMARY);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Product as(String alias) {
		return new Product(alias, this);
	}

	/**
	 * Rename this table
	 */
	public Product rename(String name) {
		return new Product(name, null);
	}
}
