/**
 * This class is generated by jOOQ
 */
package com.jz.jooq.shop.tables;


import com.jz.jooq.shop.Keys;
import com.jz.jooq.shop.Shop;
import com.jz.jooq.shop.tables.records.GoodsRecord;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

import javax.annotation.Generated;

import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.TableImpl;


/**
 * 商品信息表
 */
@Generated(
	value = {
		"http://www.jooq.org",
		"jOOQ version:3.6.2"
	},
	comments = "This class is generated by jOOQ"
)
@SuppressWarnings({ "all", "unchecked", "rawtypes" })
public class Goods extends TableImpl<GoodsRecord> {

	private static final long serialVersionUID = -1320040246;

	/**
	 * The reference instance of <code>shop.goods</code>
	 */
	public static final Goods GOODS = new Goods();

	/**
	 * The class holding records for this type
	 */
	@Override
	public Class<GoodsRecord> getRecordType() {
		return GoodsRecord.class;
	}

	/**
	 * The column <code>shop.goods.id</code>. 货品id
	 */
	public final TableField<GoodsRecord, String> ID = createField("id", org.jooq.impl.SQLDataType.VARCHAR.length(32).nullable(false), this, "货品id");

	/**
	 * The column <code>shop.goods.sku</code>. sku编号
	 */
	public final TableField<GoodsRecord, String> SKU = createField("sku", org.jooq.impl.SQLDataType.VARCHAR.length(32).nullable(false), this, "sku编号");

	/**
	 * The column <code>shop.goods.name</code>. 货品名称
	 */
	public final TableField<GoodsRecord, String> NAME = createField("name", org.jooq.impl.SQLDataType.VARCHAR.length(64).nullable(false), this, "货品名称");

	/**
	 * The column <code>shop.goods.model</code>. 货品型号
	 */
	public final TableField<GoodsRecord, String> MODEL = createField("model", org.jooq.impl.SQLDataType.VARCHAR.length(64).nullable(false), this, "货品型号");

	/**
	 * The column <code>shop.goods.weight</code>. 重量kg
	 */
	public final TableField<GoodsRecord, BigDecimal> WEIGHT = createField("weight", org.jooq.impl.SQLDataType.DECIMAL.precision(13, 2), this, "重量kg");

	/**
	 * The column <code>shop.goods.volume</code>. 体积L
	 */
	public final TableField<GoodsRecord, BigDecimal> VOLUME = createField("volume", org.jooq.impl.SQLDataType.DECIMAL.precision(13, 4), this, "体积L");

	/**
	 * The column <code>shop.goods.pic</code>. 图片
	 */
	public final TableField<GoodsRecord, String> PIC = createField("pic", org.jooq.impl.SQLDataType.VARCHAR.length(256), this, "图片");

	/**
	 * The column <code>shop.goods.unit</code>. 单位
	 */
	public final TableField<GoodsRecord, String> UNIT = createField("unit", org.jooq.impl.SQLDataType.VARCHAR.length(16), this, "单位");

	/**
	 * The column <code>shop.goods.purchase_unit</code>. 采购单位，注意跟校区订单没关系
	 */
	public final TableField<GoodsRecord, String> PURCHASE_UNIT = createField("purchase_unit", org.jooq.impl.SQLDataType.VARCHAR.length(16), this, "采购单位，注意跟校区订单没关系");

	/**
	 * The column <code>shop.goods.purchase_ratio</code>. 采购单位与库存单位换算比例，比如采购20个对应1个库存，那么这么填20
	 */
	public final TableField<GoodsRecord, Integer> PURCHASE_RATIO = createField("purchase_ratio", org.jooq.impl.SQLDataType.INTEGER.nullable(false).defaulted(true), this, "采购单位与库存单位换算比例，比如采购20个对应1个库存，那么这么填20");

	/**
	 * The column <code>shop.goods.stock_threshold</code>. 库存预警阈值
	 */
	public final TableField<GoodsRecord, Integer> STOCK_THRESHOLD = createField("stock_threshold", org.jooq.impl.SQLDataType.INTEGER, this, "库存预警阈值");

	/**
	 * The column <code>shop.goods.create_time</code>. 添加时间
	 */
	public final TableField<GoodsRecord, Long> CREATE_TIME = createField("create_time", org.jooq.impl.SQLDataType.BIGINT.nullable(false), this, "添加时间");

	/**
	 * Create a <code>shop.goods</code> table reference
	 */
	public Goods() {
		this("goods", null);
	}

	/**
	 * Create an aliased <code>shop.goods</code> table reference
	 */
	public Goods(String alias) {
		this(alias, GOODS);
	}

	private Goods(String alias, Table<GoodsRecord> aliased) {
		this(alias, aliased, null);
	}

	private Goods(String alias, Table<GoodsRecord> aliased, Field<?>[] parameters) {
		super(alias, Shop.SHOP, aliased, parameters, "商品信息表");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UniqueKey<GoodsRecord> getPrimaryKey() {
		return Keys.KEY_GOODS_PRIMARY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<UniqueKey<GoodsRecord>> getKeys() {
		return Arrays.<UniqueKey<GoodsRecord>>asList(Keys.KEY_GOODS_PRIMARY, Keys.KEY_GOODS_UNQ_SKU);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Goods as(String alias) {
		return new Goods(alias, this);
	}

	/**
	 * Rename this table
	 */
	public Goods rename(String name) {
		return new Goods(name, null);
	}
}
