/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.validate.types.list;

import com.jz.common.redis.auto.cache.annotation.types.list.TList;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.validate.types.AbstractValidate;
import java.util.Collection;
import java.util.Map;

public class TListValidate
extends AbstractValidate<TList> {
    @Override
    protected void validate(TCacheDomain cache, TList list) {
        Class<?>[] parameterTypes = cache.getCurrentMethod().getParameterTypes();
        if (list.keyArgsIndex() >= 0 && Collection.class.isAssignableFrom(parameterTypes[list.keyArgsIndex()])) {
            Class<?> returnType = cache.getCurrentMethod().getReturnType();
            if (Map.class.isAssignableFrom(returnType)) {
                return;
            }
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        this.validateReturnType(cache, false, true, false);
        if (list.startArgsIndex() >= 0 && list.sizeArgsIndex() >= 0) {
            int maxIndex = Math.max(list.keyArgsIndex(), Math.max(list.startArgsIndex(), list.sizeArgsIndex()));
            if (parameterTypes.length <= maxIndex) {
                throw new IllegalArgumentException("invalid length of parametric for [" + this.getClassMethodName(cache) + "]");
            }
            this.isInt(cache, parameterTypes[list.startArgsIndex()]);
            this.isInt(cache, parameterTypes[list.sizeArgsIndex()]);
        }
        if (null == parameterTypes || parameterTypes.length == 0 || list.keyArgsIndex() < 0) {
            this.existFixedKey(cache);
            return;
        }
        this.validateKeyType(cache, list.keyArgsIndex(), false, false);
    }
}

