/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.validate.types.hash;

import com.jz.common.redis.auto.cache.annotation.types.hash.THashSet;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.validate.types.AbstractValidate;
import com.jz.common.utils.text.StringTools;

public class THashSetValidate
extends AbstractValidate<THashSet> {
    @Override
    protected void validate(TCacheDomain cache, THashSet hashSet) {
        this.validateKeyType(cache, hashSet.keyArgsIndex());
        if (hashSet.useReturn()) {
            this.validateClassType(cache, cache.getCurrentMethod().getReturnType());
            return;
        }
        if (StringTools.isNotEmptyAndBlank((String)hashSet.value())) {
            return;
        }
        if (hashSet.valueArgsIndex() >= 0) {
            Class<?>[] parameterTypes = cache.getCurrentMethod().getParameterTypes();
            this.validateClassType(cache, parameterTypes[hashSet.valueArgsIndex()], true, false, true);
            return;
        }
        throw new IllegalArgumentException("invalid hashset args index of [" + this.getClassMethodName(cache) + "]");
    }
}

