/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.validate.types;

import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import com.jz.common.utils.text.StringTools;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;

public abstract class AbstractValidate<T extends Annotation> {
    protected String getClassMethodName(TCacheDomain cache) {
        return BeanTool.getClassMethodName(cache, ".");
    }

    protected void existFixedKey(TCacheDomain cache) {
        if (StringTools.isEmptyAndBlank((String)cache.getFixedKey())) {
            throw new IllegalArgumentException("invalid cache key config for [" + this.getClassMethodName(cache) + "]");
        }
    }

    protected void validateClassType(TCacheDomain cache, Class<?> clazz) {
        this.validateClassType(cache, clazz, true, true, true);
    }

    protected void validateClassType(TCacheDomain cache, Class<?> clazz, boolean isSelf) {
        this.validateClassType(cache, clazz, true, true, isSelf);
    }

    protected void validateClassType(TCacheDomain cache, Class<?> clazz, boolean isCollection, boolean isSelf) {
        this.validateClassType(cache, clazz, true, isCollection, isSelf);
    }

    protected void validateClassType(TCacheDomain cache, Class<?> clazz, boolean isString, boolean isCollection, boolean isSelf) {
        if (isString && String.class.isAssignableFrom(clazz)) {
            return;
        }
        if (isCollection && Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
            return;
        }
        if (isSelf && null != cache.getClass() && cache.getClazz().isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("invalid data type of parametric for [" + this.getClassMethodName(cache) + "]");
    }

    protected void validateKeyType(TCacheDomain cache, int keyArgsIndex) {
        this.validateKeyType(cache, keyArgsIndex, true, true, true);
    }

    protected void validateKeyType(TCacheDomain cache, int keyArgsIndex, boolean isSelf) {
        this.validateKeyType(cache, keyArgsIndex, true, true, isSelf);
    }

    protected void validateKeyType(TCacheDomain cache, int keyArgsIndex, boolean isCollection, boolean isSelf) {
        this.validateKeyType(cache, keyArgsIndex, true, isCollection, isSelf);
    }

    protected void validateKeyType(TCacheDomain cache, int keyArgsIndex, boolean isString, boolean isCollection, boolean isSelf) {
        Class<?>[] parameterTypes = cache.getCurrentMethod().getParameterTypes();
        if (null == parameterTypes || parameterTypes.length <= 0) {
            throw new IllegalArgumentException("nope parametric structure for [" + this.getClassMethodName(cache) + "]");
        }
        if (parameterTypes.length <= keyArgsIndex) {
            throw new IllegalArgumentException("invalid length of parametric for [" + this.getClassMethodName(cache) + "]");
        }
        this.validateClassType(cache, parameterTypes[keyArgsIndex], isString, isCollection, isSelf);
    }

    protected void isInt(TCacheDomain cache, Class<?> clazz) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("invalid data type of parametric for [" + this.getClassMethodName(cache) + "]");
    }

    protected void isDouble(TCacheDomain cache, Class<?> clazz) {
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("invalid data type of parametric for [" + this.getClassMethodName(cache) + "]");
    }

    protected void validateReturnType(TCacheDomain cache) {
        this.validateReturnType(cache, true, true, true);
    }

    protected void validateReturnType(TCacheDomain cache, boolean isSelf) {
        this.validateReturnType(cache, true, true, isSelf);
    }

    protected void validateReturnType(TCacheDomain cache, boolean isCollection, boolean isSelf) {
        this.validateReturnType(cache, true, isCollection, isSelf);
    }

    protected void validateReturnType(TCacheDomain cache, boolean isString, boolean isCollection, boolean isSelf) {
        Class<?> returnType = cache.getCurrentMethod().getReturnType();
        if (isString && String.class.isAssignableFrom(returnType)) {
            return;
        }
        if (isCollection && (returnType.isArray() || Collection.class.isAssignableFrom(returnType))) {
            return;
        }
        if (isSelf && cache.getClazz() != null && cache.getClazz().isAssignableFrom(returnType)) {
            return;
        }
        throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
    }

    protected abstract void validate(TCacheDomain var1, T var2);

    public void validate(TCacheDomain cache, Class<?> clazz, Method method, Class<? extends Annotation> annotationClass) {
        cache.setCurrentClass(clazz).setCurrentMethod(method);
        this.validate(cache, method.getAnnotation(annotationClass));
    }
}

