/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.validate.definition;

import com.google.common.collect.Maps;
import com.jz.common.redis.auto.cache.annotation.types.delete.TAfterDel;
import com.jz.common.redis.auto.cache.annotation.types.delete.TBeforeDel;
import com.jz.common.redis.auto.cache.annotation.types.hash.THash;
import com.jz.common.redis.auto.cache.annotation.types.hash.THashIncrby;
import com.jz.common.redis.auto.cache.annotation.types.hash.THashSet;
import com.jz.common.redis.auto.cache.annotation.types.list.TList;
import com.jz.common.redis.auto.cache.annotation.types.list.TLpop;
import com.jz.common.redis.auto.cache.annotation.types.set.TSet;
import com.jz.common.redis.auto.cache.annotation.types.set.TSpop;
import com.jz.common.redis.auto.cache.annotation.types.zset.TZrange;
import com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScore;
import com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScoreInf;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.tool.JedisClusterFactoryTool;
import com.jz.common.redis.auto.cache.validate.types.AbstractValidate;
import com.jz.common.redis.auto.cache.validate.types.delete.TAfterDelValidate;
import com.jz.common.redis.auto.cache.validate.types.delete.TBeforeDelValidate;
import com.jz.common.redis.auto.cache.validate.types.hash.THashIncrbyValidate;
import com.jz.common.redis.auto.cache.validate.types.hash.THashSetValidate;
import com.jz.common.redis.auto.cache.validate.types.hash.THashValidate;
import com.jz.common.redis.auto.cache.validate.types.list.TListValidate;
import com.jz.common.redis.auto.cache.validate.types.list.TLpopValidate;
import com.jz.common.redis.auto.cache.validate.types.set.TSetValidate;
import com.jz.common.redis.auto.cache.validate.types.set.TSpopValidate;
import com.jz.common.redis.auto.cache.validate.types.zset.TZrangeByScoreInfValidate;
import com.jz.common.redis.auto.cache.validate.types.zset.TZrangeByScoreValidate;
import com.jz.common.redis.auto.cache.validate.types.zset.TZrangeValidate;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidateCacheDefinition {
    @Autowired
    private JedisClusterFactoryTool jedisClusterFactory;
    private static final Map<Class<? extends Annotation>, AbstractValidate<? extends Annotation>> annotation2Instance = Maps.newHashMap();

    @PostConstruct
    public void initAnnotationValidate() {
        annotation2Instance.put(THash.class, new THashValidate());
        annotation2Instance.put(THashIncrby.class, new THashIncrbyValidate());
        annotation2Instance.put(THashSet.class, new THashSetValidate());
        annotation2Instance.put(TBeforeDel.class, new TBeforeDelValidate());
        annotation2Instance.put(TAfterDel.class, new TAfterDelValidate());
        annotation2Instance.put(TList.class, new TListValidate());
        annotation2Instance.put(TLpop.class, new TLpopValidate());
        annotation2Instance.put(TSet.class, new TSetValidate());
        annotation2Instance.put(TSpop.class, new TSpopValidate());
        annotation2Instance.put(TZrange.class, new TZrangeValidate());
        annotation2Instance.put(TZrangeByScore.class, new TZrangeByScoreValidate());
        annotation2Instance.put(TZrangeByScoreInf.class, new TZrangeByScoreInfValidate());
    }

    public void classConfig(TCacheDomain cache, Class<?> clazz) throws Exception {
        this.jedisClusterFactory.loadJedisCluster(cache);
        if (cache.getClazz() == null) {
            return;
        }
        Class<? extends Serializable> pojoClass = cache.getClazz();
        pojoClass.newInstance();
        Object[] fields = pojoClass.getDeclaredFields();
        if (ArrayMapTools.isEmpty((Object[])fields)) {
            throw new IllegalArgumentException("invalid cache pojo : [" + pojoClass.getName() + "]");
        }
        boolean existKeyField = false;
        for (Object tempField : fields) {
            if (!cache.getKeyFieldName().equals(((Field)tempField).getName())) continue;
            existKeyField = true;
            if (String.class.isAssignableFrom(((Field)tempField).getType())) break;
            throw new IllegalArgumentException("invalid key field type for [" + pojoClass.getName() + "]");
        }
        if (!existKeyField) {
            throw new IllegalArgumentException("not found key field [" + cache.getKeyFieldName() + "] for [" + pojoClass.getName() + "]");
        }
    }

    public void methodConfig(TCacheDomain cache, Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Set<Class<? extends Annotation>> annotationClasses = annotation2Instance.keySet();
        block0: for (Method tempMethod : methods) {
            if (StringTools.contains((String[])new String[]{tempMethod.getName(), "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll"})) continue;
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (!tempMethod.isAnnotationPresent(annotationClass)) continue;
                annotation2Instance.get(annotationClass).validate(cache, clazz, tempMethod, annotationClass);
                continue block0;
            }
        }
    }
}

