/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.validate.definition;

import com.google.common.collect.Lists;
import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.definition.THashCache;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import com.jz.common.redis.auto.cache.validate.definition.ValidateCacheDefinition;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AutoCacheDefinition
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(AutoCacheDefinition.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ValidateCacheDefinition validateCacheDefinition;

    public void run(String ... args) throws Exception {
        logger.info("init auto cache service...");
        if (StringTools.isEmptyAndBlank((String)this.applicationName) || "spring.application.name".equals(this.applicationName)) {
            throw new NullPointerException("spring.application.name");
        }
        BeanTool.applicationName = this.applicationName;
        List<Class<?>> classes = this.getBeans();
        for (Class<?> clazz : classes) {
            TCacheDomain cacheDomain = BeanTool.getCacheDomain(clazz);
            if (null == cacheDomain) continue;
            this.validateCacheDefinition.classConfig(cacheDomain, clazz);
            this.validateCacheDefinition.methodConfig(cacheDomain, clazz.getSuperclass());
        }
    }

    private List<Class<?>> getBeans() {
        ArrayList classes = Lists.newArrayList();
        this.addBeanClass(classes, this.applicationContext.getBeansWithAnnotation(THashCache.class));
        this.addBeanClass(classes, this.applicationContext.getBeansWithAnnotation(TCache.class));
        return classes;
    }

    private void addBeanClass(List<Class<?>> classes, Map<String, Object> beans) {
        if (ArrayMapTools.isNotEmpty(beans)) {
            classes.addAll(beans.values().stream().map(Object::getClass).collect(Collectors.toList()));
        }
    }
}

