/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.tool;

import com.google.common.collect.Maps;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.utils.text.StringTools;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class JedisClusterFactoryTool {
    private static final Map<String, JedisCluster> nane2JedisCluster = Maps.newHashMap();
    @Autowired
    private ApplicationContext applicationContext;

    public JedisCluster getJedisCluster(TCacheDomain cache) {
        return nane2JedisCluster.get(cache.getJedisBeanName());
    }

    public void loadJedisCluster(TCacheDomain cache) {
        if (nane2JedisCluster.containsKey(cache.getJedisBeanName())) {
            return;
        }
        JedisCluster tempJedisCluster = null;
        tempJedisCluster = StringTools.isEmptyAndBlank((String)cache.getJedisBeanName()) ? (JedisCluster)this.applicationContext.getBean(JedisCluster.class) : (JedisCluster)this.applicationContext.getBean(cache.getJedisBeanName(), JedisCluster.class);
        if (null == tempJedisCluster) {
            throw new NullPointerException("not found [" + cache.getJedisBeanName() + "] jedis cluster bean");
        }
        nane2JedisCluster.put(cache.getJedisBeanName(), tempJedisCluster);
    }
}

