/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.tool;

import com.google.common.collect.Lists;
import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.definition.THashCache;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.utils.text.StringTools;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;

public class BeanTool {
    public static String applicationName;

    public static String getSingle(TCacheDomain cache, String value, boolean cacheKey) {
        if (!cacheKey) {
            return value;
        }
        if (StringTools.isNotEmptyAndBlank((String)cache.getFixedKey())) {
            return cache.getFixedKey();
        }
        if (StringTools.allNotEmptyAndBlank((String[])new String[]{cache.getKeyPrefix()})) {
            return new StringBuffer(cache.getKeyPrefix()).append(value).toString();
        }
        throw new NullPointerException("invalid cache key config for [" + BeanTool.getClassMethodName(cache) + "]");
    }

    public static String getSingleForObject(TCacheDomain cache, Object obj, boolean cacheKey) throws Exception {
        String keyVal = BeanUtils.getProperty((Object)obj, (String)cache.getKeyFieldName());
        if (!cacheKey) {
            return keyVal;
        }
        if (StringTools.isEmptyAndBlank((String)keyVal)) {
            return null;
        }
        return BeanTool.getSingle(cache, keyVal, cacheKey);
    }

    public static Collection<String> getBatch(TCacheDomain cache, Collection<String> values, boolean cacheKey) {
        ArrayList cacheKeys = Lists.newArrayList();
        values.forEach(_k -> cacheKeys.add(BeanTool.getSingle(cache, _k, cacheKey)));
        return cacheKeys;
    }

    public static Collection<String> getBatchForObject(TCacheDomain cache, Collection<Object> objects, boolean cacheKey) throws Exception {
        ArrayList resultArray = Lists.newArrayList();
        for (Object tempObj : objects) {
            resultArray.add(BeanTool.getSingleForObject(cache, tempObj, cacheKey));
        }
        return resultArray;
    }

    public static TCacheDomain getCacheDomain(Class<?> clazz) {
        THashCache hashCache = BeanTool.getCacheAnnotation(clazz, THashCache.class);
        if (null != hashCache) {
            return TCacheDomain.of(hashCache);
        }
        TCache cache = BeanTool.getCacheAnnotation(clazz, TCache.class);
        if (null != cache) {
            return TCacheDomain.of(cache);
        }
        return null;
    }

    private static <T extends Annotation> T getCacheAnnotation(Class<?> clazz, Class<? extends T> annotationClass) {
        if (clazz.isAnnotationPresent(annotationClass)) {
            return clazz.getAnnotation(annotationClass);
        }
        return null;
    }

    public static String getClassMethodName(TCacheDomain cache) {
        return BeanTool.getClassMethodName(cache, ".");
    }

    public static String getClassMethodName(TCacheDomain cache, String separator) {
        return cache.getCurrentClass().getName() + separator + cache.getCurrentMethod().getName();
    }
}

