/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.storage;

import com.google.common.collect.Lists;
import com.jz.common.redis.auto.cache.domain.ZSetDomain;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.MapComparator;
import com.jz.common.utils.text.StringTools;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Tuple;

public class ZSetStorage {
    private static final Logger logger = LoggerFactory.getLogger(ZSetStorage.class);

    public static boolean zadd(ZSetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey()) || ArrayMapTools.isEmpty(domain.getMap())) {
            return true;
        }
        try {
            if (domain.getJedis().exists(domain.getKey()).booleanValue() && domain.getExistDel().booleanValue()) {
                domain.getJedis().del(domain.getKey());
            }
            domain.getJedis().zadd(domain.getKey(), domain.getMap());
            domain.getJedis().expire(domain.getKey(), domain.getExpireTime().intValue());
            return true;
        }
        catch (Exception e) {
            logger.error("set zset [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static List<Tuple> zrangeWithScore(ZSetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            int end = ZSetStorage.getEnd(domain.getStart(), domain.getSize());
            Set result = null;
            result = domain.getOrder() == MapComparator.Order.ASC ? domain.getJedis().zrangeWithScores(domain.getKey(), (long)domain.getStart().intValue(), (long)end) : domain.getJedis().zrevrangeWithScores(domain.getKey(), (long)domain.getStart().intValue(), (long)end);
            if (ArrayMapTools.isNotEmpty((Collection)result)) {
                return Lists.newArrayList((Iterable)result);
            }
            if (domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return Lists.newArrayList();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("zrange with scores [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Tuple> zrangeByScoreWithScoreForInf(ZSetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            Set<Tuple> result = null;
            result = domain.getLeftAll() != false ? ZSetStorage.zrangeByScoreWithScore(domain, "-inf", domain.getScore()) : ZSetStorage.zrangeByScoreWithScore(domain, domain.getScore(), "+inf");
            if (ArrayMapTools.isNotEmpty(result)) {
                return Lists.newArrayList(result);
            }
            if (domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return Lists.newArrayList();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("zrange by score with scores inf for [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Tuple> zrangeByScoreWithScoreForScore(ZSetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            Pair<String, String> score = ZSetStorage.getScore(domain);
            Set<Tuple> result = ZSetStorage.zrangeByScoreWithScore(domain, (String)score.getLeft(), (String)score.getRight());
            if (ArrayMapTools.isNotEmpty(result)) {
                return Lists.newArrayList(result);
            }
            if (domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return Lists.newArrayList();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("zrange by score for score [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Set<Tuple> zrangeByScoreWithScore(ZSetDomain domain, String minScore, String maxScore) {
        if (domain.getOrder() == MapComparator.Order.ASC) {
            if (null != domain.getStart() && null != domain.getSize()) {
                return domain.getJedis().zrangeByScoreWithScores(domain.getKey(), minScore, maxScore, domain.getStart().intValue(), domain.getSize().intValue());
            }
            return domain.getJedis().zrangeByScoreWithScores(domain.getKey(), minScore, maxScore);
        }
        if (null != domain.getStart() && null != domain.getSize()) {
            return domain.getJedis().zrevrangeByScoreWithScores(domain.getKey(), maxScore, minScore, domain.getStart().intValue(), domain.getSize().intValue());
        }
        return domain.getJedis().zrevrangeByScoreWithScores(domain.getKey(), maxScore, minScore);
    }

    private static int getEnd(int start, int size) {
        if (size <= 0) {
            return size;
        }
        int endNum = start + size;
        return endNum - 1 < 0 ? endNum : endNum - 1;
    }

    private static Pair<String, String> getScore(ZSetDomain domain) {
        if (domain.getDislodgeLeft().booleanValue() && domain.getDislodgeRight().booleanValue()) {
            return Pair.of((Object)("(" + domain.getMinScore()), (Object)("(" + domain.getMaxScore()));
        }
        if (domain.getDislodgeLeft().booleanValue()) {
            return Pair.of((Object)("(" + domain.getMinScore()), (Object)domain.getMaxScore().toString());
        }
        if (domain.getDislodgeRight().booleanValue()) {
            return Pair.of((Object)domain.getMinScore().toString(), (Object)("(" + domain.getMaxScore()));
        }
        return Pair.of((Object)domain.getMinScore().toString(), (Object)domain.getMaxScore().toString());
    }
}

