/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.storage;

import com.google.common.collect.Sets;
import com.jz.common.redis.auto.cache.domain.SetDomain;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetStorage {
    private static final Logger logger = LoggerFactory.getLogger(SetStorage.class);

    public static Set<String> get(SetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            Set result = domain.getJedis().smembers(domain.getKey());
            if (ArrayMapTools.isNotEmpty((Collection)result)) {
                return result;
            }
            if (domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return Sets.newHashSet();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("get smember [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean set(SetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey()) || ArrayMapTools.isEmpty(domain.getArray())) {
            return true;
        }
        try {
            if (domain.getJedis().exists(domain.getKey()).booleanValue() && domain.getExistDel().booleanValue()) {
                domain.getJedis().del(domain.getKey());
            }
            String[] array = new String[]{};
            domain.getJedis().sadd(domain.getKey(), domain.getArray().toArray(array));
            domain.getJedis().expire(domain.getKey(), domain.getExpireTime().intValue());
            return true;
        }
        catch (Exception e) {
            logger.error("set sets [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Set<String> spop(SetDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            if (!domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return null;
            }
            HashSet tempResult = Sets.newHashSet();
            int total = domain.getJedis().scard(domain.getKey()).intValue();
            if (total <= 0) {
                return tempResult;
            }
            int tempSize = domain.getSize() == -1 ? total : (total >= domain.getSize() ? domain.getSize() : total);
            for (int i = 0; i < tempSize; ++i) {
                tempResult.add(domain.getJedis().spop(domain.getKey()));
            }
            return tempResult;
        }
        catch (Exception e) {
            logger.error("spop set [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

