/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.storage;

import com.google.common.collect.Lists;
import com.jz.common.redis.auto.cache.domain.ListDomain;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListStorage {
    private static final Logger logger = LoggerFactory.getLogger(ListStorage.class);

    private static int redisEndIndex(int start, int size) {
        return size > 0 ? start + size - 1 : -1;
    }

    public static List<String> getList(ListDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            List result = domain.getJedis().lrange(domain.getKey(), (long)domain.getStart().intValue(), (long)ListStorage.redisEndIndex(domain.getStart(), domain.getSize()));
            if (ArrayMapTools.isNotEmpty((Collection)result)) {
                return result;
            }
            if (domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return Lists.newArrayList();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("get list [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean setList(ListDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey()) || ArrayMapTools.isEmpty(domain.getArray())) {
            return true;
        }
        try {
            if (domain.getJedis().exists(domain.getKey()).booleanValue() && domain.getExistDel().booleanValue()) {
                domain.getJedis().del(domain.getKey());
            }
            String[] array = new String[]{};
            if (domain.getIsRightPush().booleanValue()) {
                domain.getJedis().rpush(domain.getKey(), domain.getArray().toArray(array));
            } else {
                domain.getJedis().lpush(domain.getKey(), domain.getArray().toArray(array));
            }
            domain.getJedis().expire(domain.getKey(), domain.getExpireTime().intValue());
            return true;
        }
        catch (Exception e) {
            logger.error("set list [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static List<String> lpop(ListDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            if (!domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return null;
            }
            ArrayList tempResult = Lists.newArrayList();
            int total = domain.getJedis().llen(domain.getKey()).intValue();
            if (total <= 0) {
                return tempResult;
            }
            int tempSize = domain.getSize() == -1 ? total : (total >= domain.getSize() ? domain.getSize() : total);
            for (int i = 0; i < tempSize; ++i) {
                tempResult.add(domain.getJedis().lpop(domain.getKey()));
            }
            return tempResult;
        }
        catch (Exception e) {
            logger.error("lpop list [" + domain.getKey() + "] failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

