/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.storage;

import com.google.common.collect.Lists;
import com.jz.common.redis.auto.cache.domain.HashDomain;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class HashStorage {
    private static final Logger logger = LoggerFactory.getLogger(HashStorage.class);

    public static Object getSingle(HashDomain domain, Class<?> clazz) {
        if (null == domain.getJedis() || StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return null;
        }
        try {
            Map pojoHas = domain.getJedis().hgetAll(domain.getKey());
            if (ArrayMapTools.isEmpty((Map)pojoHas)) {
                return null;
            }
            return HashStorage.assembly(pojoHas, clazz);
        }
        catch (Exception e) {
            logger.error("get " + clazz.getSimpleName() + " info " + domain.getKey() + " failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Object> getBatch(HashDomain domain, Class<?> clazz) {
        if (null == domain.getJedis() || ArrayMapTools.isEmpty(domain.getKeys())) {
            return null;
        }
        try {
            ArrayList results = Lists.newArrayList();
            Object r = null;
            for (String tempKey : domain.getKeys()) {
                r = HashStorage.assembly(domain.getJedis().hgetAll(tempKey), clazz);
                if (null == r) continue;
                results.add(r);
            }
            return results;
        }
        catch (Exception e) {
            logger.error("multi get " + clazz.getSimpleName() + " info " + GsonTools.gson.toJson(domain.getKeys()) + " failed " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean setSingle(HashDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getKey()) || null == domain.getObj()) {
            return true;
        }
        try {
            domain.getJedis().hmset(domain.getKey(), HashStorage.disassembly(domain.getObj(), domain.getIgnore()));
            domain.getJedis().expire(domain.getKey(), domain.getExpire().intValue());
            return true;
        }
        catch (Exception e) {
            logger.error("set " + domain.getObj().getClass().getSimpleName() + " info " + GsonTools.gson.toJson(domain.getObj()) + " failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean setBatch(HashDomain domain) {
        if (ArrayMapTools.isEmpty(domain.getKey2Obj())) {
            return true;
        }
        try {
            for (Pair<String, Object> pair : domain.getKey2Obj()) {
                if (StringTools.isEmptyAndBlank((String)((String)pair.getLeft())) || null == pair.getRight()) continue;
                domain.getJedis().hmset((String)pair.getLeft(), HashStorage.disassembly(pair.getRight(), domain.getIgnore()));
                domain.getJedis().expire((String)pair.getLeft(), domain.getExpire().intValue());
            }
            return true;
        }
        catch (Exception e) {
            Pair<String, Object> pair = domain.getKey2Obj().iterator().next();
            logger.error("multi set " + pair.getRight().getClass().getSimpleName() + " info " + GsonTools.gson.toJson(domain.getKey2Obj()) + " failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean incrbySingle(HashDomain domain) {
        if (!StringTools.allNotEmptyAndBlank((String[])new String[]{domain.getFieldName(), domain.getKey()})) {
            return false;
        }
        try {
            if (!domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return true;
            }
            if (domain.getIncrbyVal() < 0) {
                String val = domain.getJedis().hget(domain.getKey(), domain.getFieldName());
                if (null == val) {
                    return true;
                }
                if (Integer.parseInt(val) < -domain.getIncrbyVal().intValue()) {
                    throw new RuntimeException("incrby [" + domain.getKey() + "].[" + domain.getFieldName() + "] = [" + domain.getIncrbyVal() + "] failed currentval : " + val);
                }
            }
            HashStorage.atomicityUpdateField(domain.getJedis(), domain.getKey(), it -> domain.getJedis().hincrBy(it, domain.getFieldName(), (long)domain.getIncrbyVal().intValue()));
            return true;
        }
        catch (Exception e) {
            logger.error("incrby [" + domain.getKey() + "] [" + domain.getFieldName() + "] = [" + domain.getIncrbyVal() + "] failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean incrbyBatch(HashDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getFieldName()) || ArrayMapTools.isEmpty(domain.getKeys())) {
            return false;
        }
        try {
            ArrayList batchUpdateKeys = Lists.newArrayList();
            for (String key : domain.getKeys()) {
                if (!domain.getJedis().exists(key).booleanValue()) continue;
                if (domain.getIncrbyVal() < 0) {
                    String val = domain.getJedis().hget(key, domain.getFieldName());
                    if (null == val) continue;
                    if (Integer.parseInt(val) < -domain.getIncrbyVal().intValue()) {
                        throw new RuntimeException("incrby [" + key + "].[" + domain.getFieldName() + "] = [" + domain.getIncrbyVal() + "] failed currentval : " + val);
                    }
                }
                batchUpdateKeys.add(key);
            }
            if (!batchUpdateKeys.isEmpty()) {
                for (String tempKey : batchUpdateKeys) {
                    HashStorage.atomicityUpdateField(domain.getJedis(), tempKey, it -> domain.getJedis().hincrBy(it, domain.getFieldName(), (long)domain.getIncrbyVal().intValue()));
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error("incrby [" + domain.getFieldName() + "] = [" + domain.getIncrbyVal() + "] failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean hashSetSingle(HashDomain domain) {
        if (!StringTools.allNotEmptyAndBlank((String[])new String[]{domain.getKey(), domain.getFieldName()})) {
            return false;
        }
        try {
            if (!domain.getJedis().exists(domain.getKey()).booleanValue()) {
                return true;
            }
            HashStorage.atomicityUpdateField(domain.getJedis(), domain.getKey(), it -> domain.getJedis().hset(it, domain.getFieldName(), domain.getValue()));
            return true;
        }
        catch (Exception e) {
            logger.error("set [" + domain.getKey() + "] [" + domain.getFieldName() + "] = [" + domain.getValue() + "]failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean hashSetBatch(HashDomain domain) {
        if (StringTools.isEmptyAndBlank((String)domain.getFieldName()) || ArrayMapTools.isEmpty(domain.getKeys())) {
            return false;
        }
        try {
            for (String key : domain.getKeys()) {
                if (!domain.getJedis().exists(key).booleanValue()) continue;
                HashStorage.atomicityUpdateField(domain.getJedis(), key, it -> domain.getJedis().hset(it, domain.getFieldName(), domain.getValue()));
            }
            return true;
        }
        catch (Exception e) {
            logger.error("batch set [" + domain.getFieldName() + "] = [" + domain.getValue() + "] failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void atomicityUpdateField(JedisCluster jedisCluster, String key, Consumer<String> updateFunction) {
        int len = jedisCluster.hlen(key).intValue();
        if (len <= 0) {
            return;
        }
        updateFunction.accept(key);
        if (jedisCluster.hlen(key).intValue() >= len) {
            return;
        }
        jedisCluster.del(key);
    }

    private static Object assembly(Map<String, String> pojoHas, Class<?> clazz) throws Exception {
        if (ArrayMapTools.isEmpty(pojoHas)) {
            return null;
        }
        Object instance = clazz.newInstance();
        BeanUtils.populate(instance, pojoHas);
        return instance;
    }

    private static Map<String, String> disassembly(Object instance, Collection<String> ignoreFields) throws Exception {
        if (null == instance) {
            return null;
        }
        Map disassembly = BeanUtils.describe((Object)instance);
        ArrayList emptyKeys = Lists.newArrayList((Object[])new String[]{"class"});
        if (ArrayMapTools.isNotEmpty(ignoreFields)) {
            emptyKeys.addAll(ignoreFields);
        }
        disassembly.forEach((k, v) -> {
            if (null == v) {
                emptyKeys.add(k);
            }
        });
        emptyKeys.forEach(disassembly::remove);
        return disassembly;
    }
}

