/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.storage;

import com.jz.common.redis.auto.cache.domain.DeleteDomain;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStorage {
    private static final Logger logger = LoggerFactory.getLogger(DeleteStorage.class);

    public static boolean delSingle(DeleteDomain domain) {
        if (null == domain.getJedis() || StringTools.isEmptyAndBlank((String)domain.getKey())) {
            return true;
        }
        try {
            domain.getJedis().del(domain.getKey());
            return true;
        }
        catch (Exception e) {
            logger.error("del " + domain.getKey() + " cache failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean delBatch(DeleteDomain domain) {
        if (null == domain.getJedis() || ArrayMapTools.isEmpty(domain.getKeys())) {
            return true;
        }
        try {
            for (String tempKey : domain.getKeys()) {
                domain.getJedis().del(tempKey);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("multi del " + GsonTools.gson.toJson(domain.getKeys()) + " cache failed " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

