/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.storage;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.JedisCluster;

abstract class AbstractHashStorage<R extends Serializable> {
    @Autowired
    protected JedisCluster jedisCluster;

    AbstractHashStorage() {
    }

    abstract Logger getLogger();

    abstract String getKey(String var1);

    abstract String getKey(R var1);

    abstract Integer getExpireTime();

    abstract Class<R> getResultClass();

    abstract Collection<String> ignoreFields();

    public R getCacheInfo(String id) {
        if (StringTools.isEmptyAndBlank((String)id)) {
            return null;
        }
        try {
            Map pojoHas = this.jedisCluster.hgetAll(this.getKey(id));
            if (ArrayMapTools.isEmpty((Map)pojoHas)) {
                return null;
            }
            return this.assembly(pojoHas);
        }
        catch (Exception e) {
            this.getLogger().error("get " + this.getResultClass().getSimpleName() + " info " + id + " failed" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<R> multiGetCacheInfo(Collection<String> idArray) {
        if (ArrayMapTools.isEmpty(idArray)) {
            return null;
        }
        try {
            ArrayList results = Lists.newArrayList();
            Object r = null;
            for (String temp : idArray) {
                r = this.assembly(this.jedisCluster.hgetAll(this.getKey(temp)));
                if (null == r) continue;
                results.add(r);
            }
            return results;
        }
        catch (Exception e) {
            this.getLogger().error("multi get " + this.getResultClass().getSimpleName() + " info " + GsonTools.gson.toJson(idArray) + " failed" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean setCacheInfo(R intance) {
        if (null == intance) {
            return true;
        }
        try {
            String key = this.getKey(intance);
            this.jedisCluster.hmset(key, this.disassembly(intance));
            this.jedisCluster.expire(key, this.getExpireTime().intValue());
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("set " + intance.getClass().getSimpleName() + " info " + GsonTools.gson.toJson(intance) + " failed" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean multiSetCacheInfo(Collection<R> instanceArray) {
        if (ArrayMapTools.isEmpty(instanceArray)) {
            return true;
        }
        try {
            for (Serializable temp : instanceArray) {
                if (temp == null) continue;
                String key = this.getKey(temp);
                this.jedisCluster.hmset(key, this.disassembly(temp));
                this.jedisCluster.expire(key, this.getExpireTime().intValue());
            }
            return true;
        }
        catch (Exception e) {
            Serializable instance = (Serializable)instanceArray.iterator().next();
            this.getLogger().error("multi set " + instance.getClass().getSimpleName() + " info " + GsonTools.gson.toJson(instanceArray) + " failed" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean deleteCacheInfo(String id) {
        if (StringTools.isEmptyAndBlank((String)id)) {
            return true;
        }
        try {
            this.jedisCluster.del(this.getKey(id));
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("delete " + this.getResultClass().getSimpleName() + " info " + id + " failed" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean multiDeleteCacheInfo(Collection<String> idArray) {
        if (ArrayMapTools.isEmpty(idArray)) {
            return true;
        }
        try {
            idArray.forEach(wid -> this.jedisCluster.del(this.getKey((String)wid)));
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("multi delete " + this.getResultClass().getSimpleName() + " info " + GsonTools.gson.toJson(idArray) + " failed" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean incrbyCacheFieldValue(String id, String fieldName, int ct) {
        if (!StringTools.allNotEmptyAndBlank((String[])new String[]{id, fieldName})) {
            return false;
        }
        String key = this.getKey(id);
        try {
            if (ct < 0) {
                String val = this.jedisCluster.hget(key, fieldName);
                if (null == val) {
                    return true;
                }
                if (Integer.parseInt(val) < -ct) {
                    throw new RuntimeException("incrby [" + key + "].[" + fieldName + "] = [" + ct + "] failed current val : " + val);
                }
            } else if (!this.jedisCluster.exists(key).booleanValue()) {
                return true;
            }
            this.jedisCluster.hincrBy(key, fieldName, (long)ct);
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("incrby [" + key + "] [" + fieldName + "] = [" + ct + "] failed" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean updateCacheFieldValue(String id, String fieldName, String val) {
        if (!StringTools.allNotEmptyAndBlank((String[])new String[]{id, fieldName})) {
            return false;
        }
        String key = this.getKey(id);
        try {
            if (!this.jedisCluster.exists(key).booleanValue()) {
                return true;
            }
            this.jedisCluster.hset(key, fieldName, val);
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("set [" + key + "] [" + fieldName + "] = [" + val + "] failed" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private R assembly(Map<String, String> pojoHas) throws Exception {
        if (ArrayMapTools.isEmpty(pojoHas)) {
            return null;
        }
        Serializable instance = (Serializable)this.getResultClass().newInstance();
        BeanUtils.populate((Object)instance, pojoHas);
        return (R)instance;
    }

    private Map<String, String> disassembly(R instance) throws Exception {
        if (null == instance) {
            return null;
        }
        Map disassembly = BeanUtils.describe(instance);
        ArrayList emptyKeys = Lists.newArrayList((Object[])new String[]{"class"});
        Collection<String> ignoreFields = this.ignoreFields();
        if (ArrayMapTools.isNotEmpty(ignoreFields)) {
            emptyKeys.addAll(ignoreFields);
        }
        disassembly.forEach((k, v) -> {
            if (null == v) {
                emptyKeys.add(k);
            }
        });
        emptyKeys.forEach(disassembly::remove);
        return disassembly;
    }
}

