/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.pointcut;

import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.types.zset.TZrange;
import com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScore;
import com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScoreInf;
import com.jz.common.redis.auto.cache.command.zset.ZrangeByScoreCommand;
import com.jz.common.redis.auto.cache.command.zset.ZrangeByScoreInfCommand;
import com.jz.common.redis.auto.cache.command.zset.ZrangeCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.pointcut.BasePointcut;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ZSetCachePointcut
extends BasePointcut {
    @Autowired
    private ZrangeCommand zrangeCommand;
    @Autowired
    private ZrangeByScoreCommand zrangeByScoreCommand;
    @Autowired
    private ZrangeByScoreInfCommand zrangeByScoreInfCommand;

    @PostConstruct
    public void initializerCommand() {
        this.addCacheBean(TZrange.class, this.zrangeCommand);
        this.addCacheBean(TZrangeByScore.class, this.zrangeByScoreCommand);
        this.addCacheBean(TZrangeByScoreInf.class, this.zrangeByScoreInfCommand);
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.zset.TZrange)")
    public void tzrange() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScore)")
    public void tzrangeByScore() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScoreInf)")
    public void tzrangeByScoreInf() {
    }

    @Around(value="tzrange() || tzrangeByScore() || tzrangeByScoreInf()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> serviceClass = pjp.getTarget().getClass();
        if (!serviceClass.isAnnotationPresent(TCache.class)) {
            return pjp.proceed();
        }
        TCache cache = serviceClass.getAnnotation(TCache.class);
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.proceed(TCacheDomain.of(cache), method, pjp);
    }
}

