/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.pointcut;

import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.types.set.TSet;
import com.jz.common.redis.auto.cache.annotation.types.set.TSpop;
import com.jz.common.redis.auto.cache.command.set.SetCommand;
import com.jz.common.redis.auto.cache.command.set.SpopCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.pointcut.BasePointcut;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class SetCachePointcut
extends BasePointcut {
    @Autowired
    private SetCommand setCommand;
    @Autowired
    private SpopCommand spopCommand;

    @PostConstruct
    public void initializerCommand() {
        this.addCacheBean(TSet.class, this.setCommand);
        this.addCacheBean(TSpop.class, this.spopCommand);
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.set.TSet)")
    public void tset() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.set.TSpop)")
    public void tspop() {
    }

    @Around(value="tset() || tspop()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> serviceClass = pjp.getTarget().getClass();
        if (!serviceClass.isAnnotationPresent(TCache.class)) {
            return pjp.proceed();
        }
        TCache cache = serviceClass.getAnnotation(TCache.class);
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.proceed(TCacheDomain.of(cache), method, pjp);
    }
}

