/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.pointcut;

import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.types.list.TList;
import com.jz.common.redis.auto.cache.annotation.types.list.TLpop;
import com.jz.common.redis.auto.cache.command.list.ListCommand;
import com.jz.common.redis.auto.cache.command.list.LpopCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.pointcut.BasePointcut;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ListCachePointcut
extends BasePointcut {
    @Autowired
    private ListCommand listCommand;
    @Autowired
    private LpopCommand lpopCommand;

    @PostConstruct
    public void initializerCommand() {
        this.addCacheBean(TList.class, this.listCommand);
        this.addCacheBean(TLpop.class, this.lpopCommand);
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.list.TList)")
    public void tlist() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.list.TLpop)")
    public void tlpop() {
    }

    @Around(value="tlist() || tlpop()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> serviceClass = pjp.getTarget().getClass();
        if (!serviceClass.isAnnotationPresent(TCache.class)) {
            return pjp.proceed();
        }
        TCache cache = serviceClass.getAnnotation(TCache.class);
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.proceed(TCacheDomain.of(cache), method, pjp);
    }
}

