/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.pointcut;

import com.jz.common.redis.auto.cache.annotation.definition.THashCache;
import com.jz.common.redis.auto.cache.annotation.types.hash.THash;
import com.jz.common.redis.auto.cache.annotation.types.hash.THashIncrby;
import com.jz.common.redis.auto.cache.annotation.types.hash.THashSet;
import com.jz.common.redis.auto.cache.command.hash.HashCommand;
import com.jz.common.redis.auto.cache.command.hash.HashIncrbyCommand;
import com.jz.common.redis.auto.cache.command.hash.HashSetCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.pointcut.BasePointcut;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class HashCachePointcut
extends BasePointcut {
    @Autowired
    private HashCommand hashCommand;
    @Autowired
    private HashIncrbyCommand hashIncrbyCommand;
    @Autowired
    private HashSetCommand hashSetCommand;

    @PostConstruct
    public void initializerCommand() {
        this.addCacheBean(THash.class, this.hashCommand);
        this.addCacheBean(THashSet.class, this.hashSetCommand);
        this.addCacheBean(THashIncrby.class, this.hashIncrbyCommand);
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.hash.THash)")
    public void thash() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.hash.THashSet)")
    public void thashSet() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.hash.THashIncrby)")
    public void thashIncrby() {
    }

    @Around(value="thash() || thashIncrby() || thashSet()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> serviceClass = pjp.getTarget().getClass();
        if (!serviceClass.isAnnotationPresent(THashCache.class)) {
            return pjp.proceed();
        }
        THashCache cache = serviceClass.getAnnotation(THashCache.class);
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.proceed(TCacheDomain.of(cache), method, pjp);
    }
}

